/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.ExceptionListener;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.DaemonRunner;
import com.sleepycat.je.utilint.Tracer;

public abstract class DaemonThread
implements DaemonRunner,
Runnable {
    private static final int JOIN_MILLIS = 10;
    private long waitTime;
    private Object synchronizer = new Object();
    private Thread thread;
    private ExceptionListener exceptionListener;
    protected String name;
    protected int nWakeupRequests;
    protected boolean stifleExceptionChatter = false;
    private volatile boolean shutdownRequest = false;
    private volatile boolean paused = false;
    private boolean running = false;
    private EnvironmentImpl envImpl;
    private static final String ERROR_LISTENER = "setErrorListener";

    public DaemonThread(long waitTime, String name, EnvironmentImpl envImpl) {
        this.waitTime = waitTime;
        this.name = name;
        this.envImpl = envImpl;
    }

    @Override
    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public Thread getThread() {
        return this.thread;
    }

    @Override
    public void runOrPause(boolean run) {
        if (run) {
            this.paused = false;
            if (this.thread != null) {
                this.wakeup();
            } else {
                this.thread = new Thread((Runnable)this, this.name);
                this.thread.setDaemon(true);
                this.thread.start();
            }
        } else {
            this.paused = true;
        }
    }

    @Override
    public void requestShutdown() {
        this.shutdownRequest = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (this.thread != null) {
            this.shutdownRequest = true;
            while (this.thread.isAlive()) {
                Object object = this.synchronizer;
                synchronized (object) {
                    this.synchronizer.notifyAll();
                }
                try {
                    this.thread.join(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.thread = null;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<DaemonThread name=\"").append(this.name).append("\"/>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        if (!this.paused) {
            Object object = this.synchronizer;
            synchronized (object) {
                this.synchronizer.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.shutdownRequest) {
            try {
                int numTries = 0;
                long maxRetries = this.nDeadlockRetries();
                while ((long)numTries <= maxRetries && !this.shutdownRequest && !this.paused) {
                    try {
                        ++this.nWakeupRequests;
                        this.running = true;
                        this.onWakeup();
                        break;
                    }
                    catch (DeadlockException deadlockException) {
                    }
                    finally {
                        this.running = false;
                    }
                    ++numTries;
                }
                if (this.shutdownRequest) continue;
                Object object = this.synchronizer;
                synchronized (object) {
                    if (this.waitTime == 0L || this.paused) {
                        this.synchronizer.wait();
                    } else {
                        this.synchronizer.wait(this.waitTime);
                    }
                }
            }
            catch (InterruptedException IE) {
                if (this.exceptionListener != null) {
                    this.exceptionListener.exceptionThrown(DbInternal.makeExceptionEvent(IE, this.name));
                }
                if (!this.stifleExceptionChatter) {
                    System.err.println("Shutting down " + this + " due to exception: " + IE);
                }
                this.shutdownRequest = true;
                assert (this.checkErrorListener(IE));
            }
            catch (Exception E) {
                if (this.exceptionListener != null) {
                    this.exceptionListener.exceptionThrown(DbInternal.makeExceptionEvent(E, this.name));
                }
                if (!this.stifleExceptionChatter) {
                    System.err.println(this + " caught exception: " + E);
                    E.printStackTrace(System.err);
                    System.err.println(this.shutdownRequest ? "Exiting" : "Continuing");
                }
                assert (this.checkErrorListener(E));
            }
            catch (Error ERR) {
                assert (this.checkErrorListener(ERR));
                throw ERR;
            }
        }
    }

    public boolean checkErrorListener(Throwable t) {
        if (Boolean.getBoolean(ERROR_LISTENER)) {
            System.err.println(this.name + " " + Tracer.getStackTrace(t));
            new RunRecoveryException(this.envImpl, "Daemon Thread Failed");
        }
        return true;
    }

    protected long nDeadlockRetries() throws DatabaseException {
        return 0L;
    }

    protected abstract void onWakeup() throws DatabaseException;

    protected boolean isShutdownRequested() {
        return this.shutdownRequest;
    }

    protected boolean isPaused() {
        return this.paused;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public int getNWakeupRequests() {
        return this.nWakeupRequests;
    }
}

