/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;
import java.sql.Timestamp;

public abstract class TxnEnd
implements Loggable {
    protected long id;
    protected Timestamp time;
    private long lastLsn;
    int repMasterNodeId;

    TxnEnd(long id, long lastLsn, int repMasterNodeId) {
        this.id = id;
        this.time = new Timestamp(System.currentTimeMillis());
        this.lastLsn = lastLsn;
        this.repMasterNodeId = repMasterNodeId;
    }

    public TxnEnd() {
        this.lastLsn = -1L;
    }

    public long getId() {
        return this.id;
    }

    public Timestamp getTime() {
        return this.time;
    }

    long getLastLsn() {
        return this.lastLsn;
    }

    public int getMasterNodeId() {
        return this.repMasterNodeId;
    }

    protected abstract String getTagName();

    @Override
    public int getLogSize() {
        return LogUtils.getPackedLongLogSize(this.id) + LogUtils.getTimestampLogSize(this.time) + LogUtils.getPackedLongLogSize(this.lastLsn) + LogUtils.getPackedIntLogSize(this.repMasterNodeId);
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writePackedLong(logBuffer, this.id);
        LogUtils.writeTimestamp(logBuffer, this.time);
        LogUtils.writePackedLong(logBuffer, this.lastLsn);
        LogUtils.writePackedInt(logBuffer, this.repMasterNodeId);
    }

    @Override
    public void readFromLog(ByteBuffer logBuffer, byte entryVersion) {
        boolean isUnpacked = entryVersion < 6;
        this.id = LogUtils.readLong(logBuffer, isUnpacked);
        this.time = LogUtils.readTimestamp(logBuffer, isUnpacked);
        this.lastLsn = LogUtils.readLong(logBuffer, isUnpacked);
        if (entryVersion >= 6) {
            this.repMasterNodeId = LogUtils.readInt(logBuffer, false);
        }
    }

    @Override
    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<").append(this.getTagName());
        sb.append(" id=\"").append(this.id);
        sb.append("\" time=\"").append(this.time);
        sb.append("\" master=\"").append(this.repMasterNodeId);
        sb.append("\">");
        sb.append(DbLsn.toString(this.lastLsn));
        sb.append("</").append(this.getTagName()).append(">");
    }

    @Override
    public long getTransactionId() {
        return this.id;
    }
}

