/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import java.nio.ByteBuffer;

public final class DupCountLN
extends LN {
    private static final String BEGIN_TAG = "<dupCountLN>";
    private static final String END_TAG = "</dupCountLN>";
    private int dupCount;

    public DupCountLN(EnvironmentImpl envImpl, int count) {
        super(new byte[0], envImpl, false);
        this.dupCount = count;
    }

    public DupCountLN() {
        this.dupCount = 0;
    }

    public int getDupCount() {
        return this.dupCount;
    }

    public int incDupCount() {
        ++this.dupCount;
        this.setDirty();
        assert (this.dupCount >= 0);
        return this.dupCount;
    }

    public int decDupCount() {
        --this.dupCount;
        this.setDirty();
        assert (this.dupCount >= 0);
        return this.dupCount;
    }

    void setDupCount(int dupCount) {
        this.dupCount = dupCount;
        this.setDirty();
    }

    @Override
    public boolean containsDuplicates() {
        return true;
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public long getMemorySizeIncludedByParent() {
        return MemoryBudget.DUPCOUNTLN_OVERHEAD;
    }

    public void accumulateStats(TreeWalkerStatsAccumulator acc) {
        acc.processDupCountLN(this, this.getNodeId());
    }

    @Override
    public String toString() {
        return this.dumpString(0, true);
    }

    @Override
    public String beginTag() {
        return BEGIN_TAG;
    }

    @Override
    public String endTag() {
        return END_TAG;
    }

    @Override
    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuffer sb = new StringBuffer();
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.beginTag());
            sb.append('\n');
        }
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<count v=\"").append(this.dupCount).append("\"/>").append('\n');
        sb.append(super.dumpString(nSpaces, false));
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.endTag());
        }
        return sb.toString();
    }

    @Override
    protected LogEntryType getTransactionalLogType() {
        return LogEntryType.LOG_DUPCOUNTLN_TRANSACTIONAL;
    }

    @Override
    public LogEntryType getLogType() {
        return LogEntryType.LOG_DUPCOUNTLN;
    }

    @Override
    public int getLogSize() {
        return super.getLogSize() + LogUtils.getPackedIntLogSize(this.dupCount);
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        super.writeToLog(logBuffer);
        LogUtils.writePackedInt(logBuffer, this.dupCount);
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, byte entryVersion) throws LogException {
        super.readFromLog(itemBuffer, entryVersion);
        this.dupCount = LogUtils.readInt(itemBuffer, entryVersion < 6);
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    @Override
    protected void dumpLogAdditional(StringBuffer sb, boolean verbose) {
        super.dumpLogAdditional(sb, verbose);
        sb.append("<count v=\"").append(this.dupCount).append("\"/>");
    }
}

