/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.tree.INDeleteInfo;
import com.sleepycat.je.tree.INDupDeleteInfo;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.txn.TxnCommit;
import com.sleepycat.je.txn.TxnEnd;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UtilizationFileReader
extends FileReader {
    private static final boolean DEBUG = true;
    private Map<Long, FileSummary> summaries = new HashMap<Long, FileSummary>();
    private Map<Long, NodeInfo> activeNodes = new HashMap<Long, NodeInfo>();
    private Map<Long, List<Object>> txns = new HashMap<Long, List<Object>>();
    private List<Object> twoEntryList = new ArrayList<Object>();

    private UtilizationFileReader(EnvironmentImpl env, int readBufferSize) throws IOException, DatabaseException {
        super(env, readBufferSize, true, -1L, null, -1L, -1L);
        this.twoEntryList.add(null);
        this.twoEntryList.add(null);
    }

    @Override
    protected boolean isTargetEntry() {
        return this.currentEntryHeader.getType() != LogEntryType.LOG_FILE_HEADER.getTypeNum();
    }

    @Override
    protected boolean processEntry(ByteBuffer entryBuffer) throws DatabaseException {
        LogEntryType lastEntryType = LogEntryType.findType(this.currentEntryHeader.getType());
        LogEntry entry = lastEntryType.getNewLogEntry();
        entry.readEntry(this.currentEntryHeader, entryBuffer, true);
        ExtendedFileSummary summary = (ExtendedFileSummary)this.summaries.get(this.readBufferFileNum);
        if (summary == null) {
            summary = new ExtendedFileSummary();
            this.summaries.put(this.readBufferFileNum, summary);
        }
        int size = this.getLastEntrySize();
        ++summary.totalCount;
        summary.totalSize += size;
        if (entry instanceof LNLogEntry) {
            LNLogEntry lnEntry = (LNLogEntry)entry;
            int otherSize = lnEntry.getLN().getLastLoggedSize();
            if (size != otherSize) {
                System.out.println("LogReader.getLastEntrySize=" + size + " LN.getLastLoggedSize=" + otherSize + " " + lnEntry.getLogType());
            }
            if (lastEntryType.isTransactional()) {
                Long txnId = lnEntry.getTransactionId();
                List<Object> txnEntries = this.txns.get(txnId);
                if (txnEntries == null) {
                    txnEntries = new ArrayList<Object>();
                    this.txns.put(txnId, txnEntries);
                }
                txnEntries.add(summary);
                txnEntries.add(lnEntry);
            } else {
                this.twoEntryList.set(0, summary);
                this.twoEntryList.set(1, lnEntry);
                this.applyTxn(this.twoEntryList, true);
            }
        } else if (entry instanceof INLogEntry) {
            INLogEntry inEntry = (INLogEntry)entry;
            Long nodeId = inEntry.getNodeId();
            ++summary.totalINCount;
            summary.totalINSize += size;
            this.countObsoleteNode(nodeId);
            this.putActiveNode(nodeId, size, summary, inEntry.getDbId().getId(), false);
        } else if (entry instanceof SingleItemEntry) {
            Long txnId;
            List<Object> txnEntries;
            Object item = ((SingleItemEntry)entry).getMainItem();
            long deletedNodeId = -1L;
            if (item instanceof INDeleteInfo) {
                deletedNodeId = ((INDeleteInfo)item).getDeletedNodeId();
            } else if (item instanceof INDupDeleteInfo) {
                deletedNodeId = ((INDupDeleteInfo)item).getDeletedNodeId();
            }
            if (deletedNodeId != -1L) {
                Long nodeId = deletedNodeId;
                this.countObsoleteNode(nodeId);
                this.activeNodes.remove(nodeId);
            }
            if (item instanceof TxnEnd && (txnEntries = this.txns.remove(txnId = Long.valueOf(((TxnEnd)item).getTransactionId()))) != null) {
                this.applyTxn(txnEntries, item instanceof TxnCommit);
            }
        }
        return true;
    }

    private void applyTxn(List<Object> entries, boolean commit) {
        for (int i = 0; i < entries.size(); i += 2) {
            ExtendedFileSummary summary = (ExtendedFileSummary)entries.get(i);
            LNLogEntry lnEntry = (LNLogEntry)entries.get(i + 1);
            LN ln = lnEntry.getLN();
            int size = ln.getLastLoggedSize();
            ++summary.totalLNCount;
            summary.totalLNSize += size;
            if (!commit || ln.isDeleted()) {
                ++summary.obsoleteLNCount;
                ExtendedFileSummary extendedFileSummary = summary;
                extendedFileSummary.recalcObsoleteLNSize = extendedFileSummary.recalcObsoleteLNSize + size;
            }
            if (commit) {
                Long nodeId = lnEntry.getNodeId();
                this.countObsoleteNode(nodeId);
                if (ln.isDeleted()) {
                    this.activeNodes.remove(nodeId);
                } else {
                    this.putActiveNode(nodeId, size, summary, lnEntry.getDbId().getId(), true);
                }
            }
            if (!commit || !ln.isDeleted() || !(ln instanceof MapLN)) continue;
            int dbId = ((MapLN)ln).getDatabase().getId().getId();
            Iterator<Map.Entry<Long, NodeInfo>> iter = this.activeNodes.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Long, NodeInfo> iEntry = iter.next();
                NodeInfo info = iEntry.getValue();
                if (info.dbId != dbId) continue;
                Long nodeId = iEntry.getKey();
                this.countObsoleteNode(nodeId);
                iter.remove();
            }
        }
    }

    private void finishProcessing() {
        for (List<Object> txnEntries : this.txns.values()) {
            this.applyTxn(txnEntries, false);
        }
    }

    private void putActiveNode(Long nodeId, int size, ExtendedFileSummary summary, int dbId, boolean isLN) {
        NodeInfo info = this.activeNodes.get(nodeId);
        if (info == null) {
            info = new NodeInfo();
            this.activeNodes.put(nodeId, info);
        }
        info.size = size;
        info.summary = summary;
        info.dbId = dbId;
        info.isLN = isLN;
    }

    private void countObsoleteNode(Long nodeId) {
        NodeInfo info = this.activeNodes.get(nodeId);
        if (info != null) {
            ExtendedFileSummary summary = info.summary;
            if (info.isLN) {
                ++summary.obsoleteLNCount;
                ExtendedFileSummary extendedFileSummary = summary;
                extendedFileSummary.recalcObsoleteLNSize = extendedFileSummary.recalcObsoleteLNSize + info.size;
            } else {
                ++summary.obsoleteINCount;
                ExtendedFileSummary extendedFileSummary = summary;
                extendedFileSummary.recalcObsoleteINSize = extendedFileSummary.recalcObsoleteINSize + info.size;
            }
        }
    }

    public static Map<Long, FileSummary> calcFileSummaryMap(EnvironmentImpl env) throws IOException, DatabaseException {
        int readBufferSize = env.getConfigManager().getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        UtilizationFileReader reader = new UtilizationFileReader(env, readBufferSize);
        while (reader.readNextEntry()) {
        }
        reader.finishProcessing();
        return reader.summaries;
    }

    private static class NodeInfo {
        ExtendedFileSummary summary;
        int size;
        int dbId;
        boolean isLN;

        private NodeInfo() {
        }
    }

    private static class ExtendedFileSummary
    extends FileSummary {
        private int recalcObsoleteINSize;
        private int recalcObsoleteLNSize;

        private ExtendedFileSummary() {
        }

        @Override
        public int getObsoleteLNSize() {
            return this.recalcObsoleteLNSize;
        }

        @Override
        public int getObsoleteINSize() {
            return this.recalcObsoleteINSize;
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(super.toString());
            buf.append("<extended-info recalcObosleteINSize=\"");
            buf.append(this.recalcObsoleteINSize);
            buf.append("\" recalcObosletedLNSize=\"");
            buf.append(this.recalcObsoleteLNSize);
            buf.append("\"/>");
            return buf.toString();
        }
    }
}

