/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.LogSource;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;

class LogBuffer
implements LogSource {
    private static final String DEBUG_NAME = LogBuffer.class.getName();
    private ByteBuffer buffer;
    private long firstLsn;
    private long lastLsn;
    private Latch readLatch;
    private boolean rewriteAllowed;

    LogBuffer(int capacity, EnvironmentImpl env) throws DatabaseException {
        this.buffer = env.useDirectNIO() ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
        this.readLatch = new Latch(DEBUG_NAME);
        this.reinit();
    }

    LogBuffer(ByteBuffer buffer, long firstLsn) throws DatabaseException {
        this.buffer = buffer;
        this.firstLsn = firstLsn;
        this.lastLsn = firstLsn;
        this.rewriteAllowed = false;
    }

    void reinit() throws DatabaseException {
        this.readLatch.acquire();
        this.buffer.clear();
        this.firstLsn = -1L;
        this.lastLsn = -1L;
        this.rewriteAllowed = false;
        this.readLatch.release();
    }

    long getFirstLsn() {
        return this.firstLsn;
    }

    void registerLsn(long lsn) throws DatabaseException {
        this.readLatch.acquire();
        try {
            if (this.lastLsn != -1L) assert (DbLsn.compareTo(lsn, this.lastLsn) > 0) : "lsn=" + lsn + " lastlsn=" + this.lastLsn;
            this.lastLsn = lsn;
            if (this.firstLsn == -1L) {
                this.firstLsn = lsn;
            }
        }
        finally {
            this.readLatch.release();
        }
    }

    boolean hasRoom(int numBytes) {
        return numBytes <= this.buffer.capacity() - this.buffer.position();
    }

    ByteBuffer getDataBuffer() {
        return this.buffer;
    }

    int getCapacity() {
        return this.buffer.capacity();
    }

    boolean containsLsn(long lsn) throws DatabaseException {
        this.readLatch.acquire();
        boolean found = false;
        if (this.firstLsn != -1L && DbLsn.compareTo(this.firstLsn, lsn) <= 0 && DbLsn.compareTo(this.lastLsn, lsn) >= 0) {
            found = true;
        }
        if (found) {
            return true;
        }
        this.readLatch.release();
        return false;
    }

    public void latchForWrite() throws DatabaseException {
        this.readLatch.acquire();
    }

    @Override
    public void release() throws DatabaseException {
        this.readLatch.releaseIfOwner();
    }

    boolean getRewriteAllowed() {
        return this.rewriteAllowed;
    }

    void setRewriteAllowed() {
        this.rewriteAllowed = true;
    }

    @Override
    public ByteBuffer getBytes(long fileOffset) {
        ByteBuffer copy = null;
        while (true) {
            try {
                copy = this.buffer.duplicate();
                copy.position((int)(fileOffset - DbLsn.getFileOffset(this.firstLsn)));
            }
            catch (IllegalArgumentException IAE) {
                continue;
            }
            break;
        }
        return copy;
    }

    @Override
    public ByteBuffer getBytes(long fileOffset, int numBytes) {
        ByteBuffer copy = this.getBytes(fileOffset);
        assert (copy.remaining() >= numBytes) : "copy.remaining=" + copy.remaining() + " numBytes=" + numBytes;
        return copy;
    }
}

