/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.jmx;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.jmx.JEMBeanHelper;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;

public class JEMonitor
implements DynamicMBean {
    private static final String DESCRIPTION = "Monitor an open Berkeley DB, Java Edition environment.";
    private MBeanInfo mbeanInfo;
    private JEMBeanHelper jeHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JEMonitor(String environmentHome) throws MBeanException {
        File environmentDirectory = new File(environmentHome);
        this.jeHelper = new JEMBeanHelper(environmentDirectory, false);
        Environment targetEnv = this.getEnvironmentIfOpen();
        try {
            this.resetMBeanInfo(targetEnv);
        }
        finally {
            this.closeEnvironment(targetEnv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException {
        Object result = null;
        Environment targetEnv = this.getEnvironmentIfOpen();
        try {
            result = this.jeHelper.getAttribute(targetEnv, attributeName);
            targetEnv = this.checkForMBeanReset(targetEnv);
        }
        finally {
            this.closeEnvironment(targetEnv);
        }
        return result;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException {
        Environment targetEnv = this.getEnvironmentIfOpen();
        try {
            this.jeHelper.setAttribute(targetEnv, attribute);
        }
        finally {
            this.closeEnvironment(targetEnv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttributeList getAttributes(String[] attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Attributes cannot be null");
        }
        AttributeList results = new AttributeList();
        Environment targetEnv = this.getEnvironmentIfOpen();
        try {
            for (int i = 0; i < attributes.length; ++i) {
                try {
                    String name = attributes[i];
                    Object value = this.jeHelper.getAttribute(targetEnv, name);
                    targetEnv = this.checkForMBeanReset(targetEnv);
                    results.add(new Attribute(name, value));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            AttributeList attributeList = results;
            return attributeList;
        }
        finally {
            try {
                this.closeEnvironment(targetEnv);
            }
            catch (MBeanException mBeanException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("attribute list can't be null");
        }
        AttributeList results = new AttributeList();
        Environment targetEnv = this.getEnvironmentIfOpen();
        try {
            for (int i = 0; i < attributes.size(); ++i) {
                Attribute attr = (Attribute)attributes.get(i);
                try {
                    this.jeHelper.setAttribute(targetEnv, attr);
                    String name = attr.getName();
                    Object newValue = this.jeHelper.getAttribute(targetEnv, name);
                    results.add(new Attribute(name, newValue));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            AttributeList attributeList = results;
            return attributeList;
        }
        finally {
            try {
                this.closeEnvironment(targetEnv);
            }
            catch (MBeanException mBeanException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException {
        Object result = null;
        Environment targetEnv = this.getEnvironmentIfOpen();
        try {
            result = this.jeHelper.invoke(targetEnv, actionName, params, signature);
        }
        finally {
            this.closeEnvironment(targetEnv);
        }
        return result;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    private Environment checkForMBeanReset(Environment targetEnv) throws MBeanException {
        Environment env = targetEnv;
        if (this.jeHelper.getNeedReset()) {
            this.closeEnvironment(env);
            env = this.getEnvironmentIfOpen();
            this.resetMBeanInfo(env);
        }
        return env;
    }

    private void resetMBeanInfo(Environment targetEnv) {
        List<MBeanAttributeInfo> attributeList = this.jeHelper.getAttributeList(targetEnv);
        MBeanAttributeInfo[] attributeInfo = new MBeanAttributeInfo[attributeList.size()];
        attributeList.toArray(attributeInfo);
        Constructor<?>[] constructors = this.getClass().getConstructors();
        MBeanConstructorInfo[] constructorInfo = new MBeanConstructorInfo[constructors.length];
        for (int i = 0; i < constructors.length; ++i) {
            constructorInfo[i] = new MBeanConstructorInfo(this.getClass().getName(), constructors[i]);
        }
        List<MBeanOperationInfo> operationList = this.jeHelper.getOperationList(targetEnv);
        MBeanOperationInfo[] operationInfo = new MBeanOperationInfo[operationList.size()];
        operationList.toArray(operationInfo);
        MBeanNotificationInfo[] notificationInfo = this.jeHelper.getNotificationInfo(targetEnv);
        this.mbeanInfo = new MBeanInfo(this.getClass().getName(), DESCRIPTION, attributeInfo, constructorInfo, operationInfo, notificationInfo);
    }

    protected Environment getEnvironmentIfOpen() {
        return this.jeHelper.getEnvironmentIfOpen();
    }

    protected void closeEnvironment(Environment targetEnv) throws MBeanException {
        try {
            if (targetEnv != null) {
                targetEnv.close();
            }
        }
        catch (DatabaseException e) {
            throw new MBeanException(e);
        }
    }
}

