/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.MarshalledTupleEntry;
import com.sleepycat.bind.tuple.MarshalledTupleKeyEntity;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.bind.tuple.TupleTupleBinding;
import com.sleepycat.util.RuntimeExceptionWrapper;

public class TupleTupleMarshalledBinding<E extends MarshalledTupleEntry & MarshalledTupleKeyEntity>
extends TupleTupleBinding<E> {
    private Class<E> cls;

    public TupleTupleMarshalledBinding(Class<E> cls) {
        this.cls = cls;
        if (!MarshalledTupleKeyEntity.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException(cls.toString() + " does not implement MarshalledTupleKeyEntity");
        }
        if (!MarshalledTupleEntry.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException(cls.toString() + " does not implement MarshalledTupleEntry");
        }
    }

    @Override
    public E entryToObject(TupleInput keyInput, TupleInput dataInput) {
        MarshalledTupleEntry obj;
        try {
            obj = (MarshalledTupleEntry)this.cls.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeExceptionWrapper(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeExceptionWrapper(e);
        }
        if (dataInput != null) {
            obj.unmarshalEntry(dataInput);
        }
        if (keyInput != null) {
            ((MarshalledTupleKeyEntity)((Object)obj)).unmarshalPrimaryKey(keyInput);
        }
        return (E)obj;
    }

    @Override
    public void objectToKey(E object, TupleOutput output) {
        ((MarshalledTupleKeyEntity)object).marshalPrimaryKey(output);
    }

    @Override
    public void objectToData(E object, TupleOutput output) {
        object.marshalEntry(output);
    }
}

