/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.memcached.route;

import com.gemantic.dal.cache.exception.StrategyException;
import com.gemantic.dal.cache.route.ContextHolder;
import com.gemantic.dal.cache.route.RoutingService;
import com.gemantic.dal.cache.route.strategy.IStrategy;
import com.gemantic.memcached.config.helper.CacheConfigHelper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RoutingServiceImpl
implements RoutingService {
    private static Logger logger = Logger.getLogger(RoutingServiceImpl.class);
    private static Map<String, IStrategy> objectStrategy = new ConcurrentHashMap<String, IStrategy>();
    private static RoutingService routingService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RoutingService getInstance() {
        if (routingService != null) return routingService;
        Class<RoutingServiceImpl> clazz = RoutingServiceImpl.class;
        synchronized (RoutingServiceImpl.class) {
            routingService = new RoutingServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return routingService;
        }
    }

    private RoutingServiceImpl() {
    }

    @Override
    public boolean setRoutingStrategy(String regionName, Object key) throws StrategyException {
        IStrategy strategy = objectStrategy.get(regionName);
        if (strategy == null) {
            String className = null;
            try {
                className = CacheConfigHelper.getStrategyClassName(regionName);
                if (StringUtils.isNotEmpty((String)className)) {
                    strategy = (IStrategy)Class.forName(className).newInstance();
                    objectStrategy.put(className, strategy);
                } else {
                    logger.error((Object)(StringUtils.defaultIfEmpty((String)regionName, (String)"") + " region strategyClass property must have value, please set in memcahced_client.xml"));
                }
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    e.printStackTrace(System.err);
                }
                logger.error((Object)("don't instance " + StringUtils.defaultIfEmpty((String)className, (String)"")));
            }
        }
        if (strategy != null) {
            ContextHolder.setCachdName(String.valueOf(strategy.playStrategy(regionName, key)));
        }
        return false;
    }
}

