/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.memcached.channel.pool;

import com.gemantic.memcached.channel.MemcachedChannel;
import com.gemantic.memcached.channel.pool.MChannelFactory;
import com.gemantic.memcached.channel.pool.MemcachedChannelPoolableObject;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.log4j.Logger;

public class MChannellPoolableObjectFactory
implements PoolableObjectFactory {
    private static Logger logger = Logger.getLogger(MChannellPoolableObjectFactory.class);
    protected MChannelFactory channelFactory = null;
    protected ObjectPool pool = null;

    public MChannellPoolableObjectFactory(MChannelFactory channelFactory, ObjectPool pool) {
        this.pool = pool;
        pool.setFactory((PoolableObjectFactory)this);
        this.channelFactory = channelFactory;
    }

    public void activateObject(Object obj) throws Exception {
    }

    public void destroyObject(Object obj) throws Exception {
        if (obj instanceof MemcachedChannelPoolableObject) {
            MemcachedChannelPoolableObject poolableObject = (MemcachedChannelPoolableObject)obj;
            poolableObject.trueClose();
        }
    }

    public Object makeObject() throws Exception {
        MemcachedChannel channel = this.channelFactory.createMemcachedChannel();
        if (channel != null) {
            channel = new MemcachedChannelPoolableObject(channel, this.pool);
        }
        return channel;
    }

    public void passivateObject(Object obj) throws Exception {
        MemcachedChannelPoolableObject poolableObject;
        if (obj instanceof MemcachedChannelPoolableObject && !(poolableObject = (MemcachedChannelPoolableObject)obj).isHealth()) {
            throw new Exception("MemcachedChannelPoolableObject passivate fail.");
        }
    }

    public boolean validateObject(Object obj) {
        if (obj instanceof MemcachedChannelPoolableObject) {
            MemcachedChannelPoolableObject poolableObject = (MemcachedChannelPoolableObject)obj;
            return poolableObject.isHealth();
        }
        return false;
    }
}

