/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dmemcached.config.helper;

import com.gemantic.dal.cache.client.CacheClient;
import com.gemantic.dal.cache.config.model.KeyPatternItem;
import com.gemantic.dal.cache.config.model.RegionItem;
import com.gemantic.dmemcached.config.CacheConfig;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class CacheConfigHelper {
    private static Logger logger = Logger.getLogger(CacheConfigHelper.class);

    public static Map<String, KeyPatternItem> getKeyKeyPatternItems(String regionName) {
        if (StringUtils.isNotEmpty((String)regionName)) {
            RegionItem regionItem = CacheConfig.getInstance().getRegionItem(regionName);
            if (regionItem == null) {
                logger.error((Object)("don't find the " + regionName + " RegionItem in " + CacheConfig.CONFIG_FILE));
                return null;
            }
            return regionItem.getKeyPatternMap();
        }
        logger.error((Object)"region name must have a value");
        return null;
    }

    public static Map<String, KeyPatternItem> getDefaultKeyKeyPatternItems() {
        RegionItem regionItem = CacheConfig.getInstance().getDefaultRegionItem();
        if (regionItem == null) {
            logger.error((Object)("cannot find the default RegionItem in " + CacheConfig.CONFIG_FILE));
            return null;
        }
        return regionItem.getKeyPatternMap();
    }

    public static CacheClient getCacheClient(String name) {
        return StringUtils.isNotEmpty((String)name) ? CacheConfig.getInstance().getCacheClient(name) : null;
    }

    public static CacheClient getDynamicCacheClient() {
        return CacheConfig.getInstance().getDynamicCacheClient();
    }

    public static String getStrategyClassName(String regionName) {
        if (StringUtils.isNotEmpty((String)regionName)) {
            RegionItem regionItem = CacheConfig.getInstance().getRegionItem(regionName);
            if (regionItem != null) {
                return regionItem.getStrategyClass();
            }
            logger.error((Object)("don't find regionName config: " + regionName));
            return null;
        }
        logger.error((Object)"regionName is null or empty");
        return null;
    }

    public static String getListenerClass(String regionName) {
        if (StringUtils.isNotEmpty((String)regionName)) {
            RegionItem regionItem = CacheConfig.getInstance().getRegionItem(regionName);
            if (regionItem != null) {
                return regionItem.getListenerClass();
            }
            logger.error((Object)("don't find regionName config: " + regionName));
            return null;
        }
        logger.error((Object)"regionName is null or empty");
        return null;
    }

    public static boolean isExistRegion(String regionName) {
        if (StringUtils.isNotEmpty((String)regionName)) {
            RegionItem regionItem = CacheConfig.getInstance().getRegionItem(regionName);
            return regionItem != null;
        }
        return false;
    }

    public static boolean isLocalCache(String regionName) {
        if (StringUtils.isNotEmpty((String)regionName)) {
            RegionItem regionItem = CacheConfig.getInstance().getRegionItem(regionName);
            return regionItem == null ? false : regionItem.isLocalCache();
        }
        return false;
    }
}

