/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dmemcached;

import com.gemantic.dal.cache.Cache;
import com.gemantic.dal.cache.CacheFactory;
import com.gemantic.dal.cache.client.CacheClient;
import com.gemantic.dal.cache.impl.CacheImpl;
import com.gemantic.dal.cache.listener.Listener;
import com.gemantic.dmemcached.config.helper.CacheConfigHelper;
import com.gemantic.dmemcached.route.RoutingServiceImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CacheFactoryImpl
implements CacheFactory {
    private static Logger logger = Logger.getLogger(CacheFactoryImpl.class);
    private static CacheFactory cacheFactory;
    private Map<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private CacheClient cacheClient;
    private CacheClient dCacheClient;
    private Lock lock = new ReentrantLock(false);

    private CacheFactoryImpl() {
        this.init();
    }

    private void init() {
        this.cacheClient = CacheConfigHelper.getCacheClient("default");
        this.dCacheClient = CacheConfigHelper.getDynamicCacheClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheFactory getInstance() {
        if (cacheFactory != null) return cacheFactory;
        Class<CacheFactoryImpl> clazz = CacheFactoryImpl.class;
        synchronized (CacheFactoryImpl.class) {
            if (cacheFactory != null) return cacheFactory;
            cacheFactory = new CacheFactoryImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return cacheFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cache getCache(String name) {
        CacheClient cacheClient;
        Cache cache;
        block10: {
            cache = null;
            if (StringUtils.isEmpty((String)name)) {
                logger.warn((Object)"cache name must have value");
                return null;
            }
            cache = this.caches.get(name);
            if (cache == null) {
                if (!CacheConfigHelper.isExistRegion(name)) {
                    return null;
                }
                this.lock.lock();
                try {
                    cache = this.caches.get(name);
                    if (cache != null || (cache = new CacheImpl(name, this.cacheClient, RoutingServiceImpl.getInstance())) == null) break block10;
                    String listenerClass = CacheConfigHelper.getListenerClass(name);
                    Listener listener = null;
                    if (StringUtils.isNotEmpty((String)listenerClass)) {
                        try {
                            listener = (Listener)Class.forName(listenerClass).newInstance();
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage());
                            e.printStackTrace(System.err);
                        }
                    }
                    cache.regListener(listener);
                    ((CacheImpl)cache).setEnableLocalCache(CacheConfigHelper.isLocalCache(name));
                    this.caches.put(name, cache);
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        if (cache != null && (cacheClient = ((CacheImpl)cache).getClient()).isDynamic()) {
            throw new RuntimeException("Cache must is  singleness module");
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cache getCache(String name, boolean isDynamic) {
        CacheClient cacheClient;
        Cache cache;
        block11: {
            cache = null;
            if (StringUtils.isEmpty((String)name)) {
                logger.warn((Object)"cache name must have value");
                return null;
            }
            cache = this.caches.get(name);
            if (cache == null) {
                if (!CacheConfigHelper.isExistRegion(name)) {
                    return null;
                }
                this.lock.lock();
                try {
                    cache = this.caches.get(name);
                    if (cache != null) break block11;
                    String listenerClass = CacheConfigHelper.getListenerClass(name);
                    Listener listener = null;
                    if (StringUtils.isNotEmpty((String)listenerClass)) {
                        try {
                            listener = (Listener)Class.forName(listenerClass).newInstance();
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage());
                            e.printStackTrace(System.err);
                        }
                    }
                    if ((cache = isDynamic ? new CacheImpl(name, this.dCacheClient, RoutingServiceImpl.getInstance()) : new CacheImpl(name, this.cacheClient, RoutingServiceImpl.getInstance())) != null) {
                        cache.regListener(listener);
                        ((CacheImpl)cache).setEnableLocalCache(CacheConfigHelper.isLocalCache(name));
                        this.caches.put(name, cache);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        if (cache != null && (cacheClient = ((CacheImpl)cache).getClient()).isDynamic() != isDynamic) {
            throw new RuntimeException("Cache don't match specify Dynamic module");
        }
        return cache;
    }

    @Override
    public void removeCache(String name) {
        if (StringUtils.isNotEmpty((String)name)) {
            this.caches.remove(name);
        }
    }
}

