/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.cache.impl;

import com.gemantic.binding.binding.BindingHelper;
import com.gemantic.dal.cache.Cache;
import com.gemantic.dal.cache.CacheUtil;
import com.gemantic.dal.cache.LocalCacheFactory;
import com.gemantic.dal.cache.client.CacheClient;
import com.gemantic.dal.cache.exception.CacheException;
import com.gemantic.dal.cache.listener.Listener;
import com.gemantic.dal.cache.route.ContextHolder;
import com.gemantic.dal.cache.route.RoutingService;
import com.gemantic.utils.DebugTimeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CacheImpl
implements Cache {
    private static Logger logger = Logger.getLogger(CacheImpl.class);
    private String regionName;
    private CacheClient client;
    private boolean hasRoute = false;
    private RoutingService routingService;
    private Listener listener;
    private boolean enableLocalCache = false;
    private boolean enableDelMark = false;
    private Map<String, Object> delMarkMap = Collections.synchronizedMap(new LRUMap(5000));
    private Cache localCache;
    private boolean hasClassInfo = true;
    private static final byte DELETE_BYTE = 49;

    public boolean isHasClassInfo() {
        return this.hasClassInfo;
    }

    public void setHasClassInfo(boolean hasClassInfo) {
        this.hasClassInfo = hasClassInfo;
    }

    public CacheImpl() {
    }

    public CacheImpl(String region, CacheClient client, RoutingService routingService) {
        this.client = client;
        this.regionName = region;
        this.hasRoute = client.isDynamic();
        this.routingService = routingService;
        if (this.hasRoute && this.routingService == null) {
            throw new RuntimeException("Must set RoutingService, because CacheClient is Dynamic CacheClient!");
        }
        if (StringUtils.isEmpty((String)this.regionName)) {
            throw new RuntimeException("region name must have value!");
        }
    }

    @Override
    public boolean delete(String key) throws CacheException {
        DebugTimeUtils.begTime();
        if (StringUtils.isEmpty((String)key)) {
            logger.info((Object)("region: " + StringUtils.defaultIfEmpty((String)this.regionName, (String)"") + " key is empty or null"));
            return false;
        }
        boolean b = false;
        String sTempKey = CacheUtil.keyEncode(this.regionName, key);
        String sDelMarkKey = CacheUtil.delMarkKey(this.regionName, key);
        this.exeBeforeListener(key, null, "delete");
        if (this.enableLocalCache) {
            this.getLocalCache().delete(key);
            if (this.enableDelMark) {
                this.getLocalCache().put(sDelMarkKey, Boolean.TRUE);
            }
        }
        try {
            if (this.hasRoute) {
                this.routingService.setRoutingStrategy(this.regionName, key);
            }
            b = this.client.delete(sTempKey);
            if (this.enableDelMark) {
                if (this.isHasClassInfo()) {
                    this.client.set(sDelMarkKey, Boolean.TRUE);
                } else {
                    this.client.set(sDelMarkKey, (byte)49);
                }
            }
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        this.exeAfterListener(key, null, "delete");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("delete time : " + DebugTimeUtils.getDistanceTime()));
        }
        return b;
    }

    @Override
    public boolean remove(String key) throws CacheException {
        DebugTimeUtils.begTime();
        if (StringUtils.isEmpty((String)key)) {
            logger.info((Object)("region: " + StringUtils.defaultIfEmpty((String)this.regionName, (String)"") + " key is empty or null"));
            return false;
        }
        boolean b = false;
        String sTempKey = CacheUtil.keyEncode(this.regionName, key);
        this.exeBeforeListener(key, null, "remove");
        if (this.enableLocalCache) {
            this.getLocalCache().remove(key);
        }
        try {
            if (this.hasRoute) {
                this.routingService.setRoutingStrategy(this.regionName, key);
            }
            b = this.client.remove(sTempKey);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        this.exeAfterListener(key, null, "remove");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("delete time : " + DebugTimeUtils.getDistanceTime()));
        }
        return b;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object get(String key) throws CacheException {
        DebugTimeUtils.begTime();
        if (StringUtils.isEmpty((String)key)) {
            CacheImpl.logger.info((Object)("region: " + StringUtils.defaultIfEmpty((String)this.regionName, (String)"") + " key is empty or null"));
            return null;
        }
        o = null;
        this.exeBeforeListener(key, null, "get");
        sDelMarkKey = CacheUtil.delMarkKey(this.regionName, key);
        if (this.enableLocalCache) {
            o = this.getLocalCache().get(key);
            if (this.enableDelMark && o != null && (b = (Boolean)this.getLocalCache().get(sDelMarkKey)) != null && b.booleanValue()) {
                this.putDelKey(key);
                if (o != null) {
                    this.getLocalCache().delete(key);
                }
                return null;
            }
        }
        if (o == null) {
            sTempKey = CacheUtil.keyEncode(this.regionName, key);
            try {
                if (this.hasRoute) {
                    this.routingService.setRoutingStrategy(this.regionName, key);
                }
                if (this.enableDelMark) {
                    keys = new String[]{sTempKey, sDelMarkKey};
                    rets = this.client.getMultiArray(keys);
                    if (!ArrayUtils.isEmpty((Object[])rets)) {
                        if (rets.length > 1 && rets[1] != null) {
                            this.putDelKey(key);
                            if (this.enableLocalCache && this.enableDelMark) {
                                this.getLocalCache().put(sDelMarkKey, Boolean.TRUE);
                            }
                            o = null;
                        } else {
                            o = rets[0];
                        }
                    }
                } else {
                    o = this.client.get(sTempKey);
                }
                if (o != null && !this.isHasClassInfo()) {
                    o = BindingHelper.getObjectFromByte((byte[])o, this.regionName);
                }
                if (!this.enableLocalCache || o == null) ** GOTO lbl46
                this.getLocalCache().put(key, o);
            }
            catch (Exception e) {
                throw new CacheException(e);
            }
        } else if (CacheImpl.logger.isDebugEnabled()) {
            CacheImpl.logger.info((Object)"location cache have value");
        }
lbl46:
        // 5 sources

        this.exeAfterListener(key, o, "get");
        if (CacheImpl.logger.isDebugEnabled()) {
            CacheImpl.logger.debug((Object)("get time : " + DebugTimeUtils.getDistanceTime()));
        }
        return o;
    }

    @Override
    public boolean put(String key, Object value) throws CacheException {
        DebugTimeUtils.begTime();
        if (StringUtils.isEmpty((String)key) || value == null) {
            logger.info((Object)("region: " + StringUtils.defaultIfEmpty((String)this.regionName, (String)"") + " key is empty or value is null"));
            return false;
        }
        boolean bResult = false;
        this.exeBeforeListener(key, value, "put");
        if (this.enableLocalCache) {
            this.getLocalCache().put(key, value);
        }
        String sTempKey = CacheUtil.keyEncode(this.regionName, key);
        try {
            if (this.hasRoute) {
                this.routingService.setRoutingStrategy(this.regionName, key);
            }
            Object mValue = this.isHasClassInfo() ? value : (Object)BindingHelper.getByteFromObject(value);
            bResult = this.client.set(sTempKey, mValue);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        this.exeAfterListener(key, value, "put");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("put time : " + DebugTimeUtils.getDistanceTime()));
        }
        return bResult;
    }

    @Override
    public boolean update(String key, Object value) throws CacheException {
        DebugTimeUtils.begTime();
        boolean b = false;
        if (StringUtils.isEmpty((String)key) || value == null) {
            logger.info((Object)("region: " + StringUtils.defaultIfEmpty((String)this.regionName, (String)"") + " key is empty or value is null"));
            return false;
        }
        this.exeBeforeListener(key, value, "update");
        if (this.enableLocalCache) {
            this.getLocalCache().update(key, value);
        }
        String sTempKey = CacheUtil.keyEncode(this.regionName, key);
        try {
            if (this.hasRoute) {
                this.routingService.setRoutingStrategy(this.regionName, key);
            }
            Object mValue = this.isHasClassInfo() ? value : (Object)BindingHelper.getByteFromObject(value);
            b = this.client.set(sTempKey, mValue);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        this.exeAfterListener(key, value, "update");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("put time : " + DebugTimeUtils.getDistanceTime()));
        }
        return b;
    }

    @Override
    public String getRegion() throws CacheException {
        return this.regionName;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public CacheClient getClient() {
        return this.client;
    }

    public void setClient(CacheClient client) {
        this.client = client;
    }

    public boolean isHasRoute() {
        return this.hasRoute;
    }

    public void setHasRoute(boolean hasRoute) {
        this.hasRoute = hasRoute;
    }

    public RoutingService getRoutingService() {
        return this.routingService;
    }

    public void setRoutingService(RoutingService routingService) {
        this.routingService = routingService;
    }

    @Override
    public void regListener(Listener listener) {
        this.listener = listener;
    }

    private Cache getLocalCache() {
        if (this.localCache == null) {
            this.localCache = LocalCacheFactory.getInstance().getCache(this.regionName);
        }
        return this.localCache;
    }

    private void exeBeforeListener(Object key, Object value, String operateMethod) {
        if (this.listener != null) {
            this.listener.beforeListener((Cache)this, key, value, operateMethod);
        }
    }

    private void exeAfterListener(Object key, Object value, String operateMethod) {
        if (this.listener != null) {
            this.listener.afterListener((Cache)this, key, value, operateMethod);
        }
    }

    private void exeBeforeListener(Object[] keys, Object[] values, String operateMethod) {
        if (this.listener != null) {
            this.listener.beforeListener((Cache)this, keys, values, operateMethod);
        }
    }

    private void exeAfterListener(Object[] keys, Object[] values, String operateMethod) {
        if (this.listener != null) {
            this.listener.afterListener((Cache)this, keys, values, operateMethod);
        }
    }

    @Override
    public boolean save(String key, Object value) throws CacheException {
        DebugTimeUtils.begTime();
        if (StringUtils.isEmpty((String)key) || value == null) {
            logger.info((Object)("region: " + StringUtils.defaultIfEmpty((String)this.regionName, (String)"") + " key is empty or value is null"));
            return false;
        }
        boolean bResult = false;
        this.exeBeforeListener(key, value, "put");
        if (this.enableLocalCache) {
            this.getLocalCache().save(key, value);
        }
        String sTempKey = CacheUtil.keyEncode(this.regionName, key);
        try {
            if (this.hasRoute) {
                this.routingService.setRoutingStrategy(this.regionName, key);
            }
            Object mValue = this.isHasClassInfo() ? value : (Object)BindingHelper.getByteFromObject(value);
            bResult = this.client.set(sTempKey, mValue);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        this.exeAfterListener(key, value, "put");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("put time : " + DebugTimeUtils.getDistanceTime()));
        }
        return bResult;
    }

    private void putDelKey(String key) {
        if (!this.delMarkMap.containsKey(key)) {
            this.delMarkMap.put(key, Boolean.TRUE);
        }
    }

    @Override
    public boolean isDelete(String key) throws CacheException {
        if (this.enableDelMark) {
            return this.delMarkMap.containsKey(key);
        }
        return false;
    }

    public void setEnableLocalCache(boolean enableLocalCache) {
        this.enableLocalCache = enableLocalCache;
    }

    @Override
    public Object[] get(String[] keys) throws CacheException {
        DebugTimeUtils.begTime();
        if (ArrayUtils.isEmpty((Object[])keys)) {
            logger.info((Object)("region: " + StringUtils.defaultIfEmpty((String)this.regionName, (String)"") + " keys is empty or null"));
            return null;
        }
        this.exeBeforeListener(keys, null, "get");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<String> memCacheKeys = new ArrayList<String>();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (null == key) continue;
            if (this.enableLocalCache) {
                Iterator o = this.getLocalCache().get(key);
                if (this.enableDelMark) {
                    String sDelMarkKey = CacheUtil.delMarkKey(this.regionName, key);
                    Boolean b = (Boolean)this.getLocalCache().get(sDelMarkKey);
                    if (b != null && b.booleanValue()) {
                        this.putDelKey(key);
                    }
                }
                if (null != o) {
                    resultMap.put(key, o);
                    continue;
                }
                memCacheKeys.add(key);
                continue;
            }
            memCacheKeys.add(key);
        }
        if (memCacheKeys.size() > 0) {
            HashMap sourceMap = new HashMap();
            HashMap delMarkSourceMap = new HashMap();
            for (String key : memCacheKeys) {
                String cacheName;
                ArrayList<String> sourceKeys;
                if (this.hasRoute) {
                    try {
                        this.routingService.setRoutingStrategy(this.regionName, key);
                    }
                    catch (Exception e) {
                        throw new CacheException(e);
                    }
                }
                if ((sourceKeys = (ArrayList<String>)sourceMap.get(cacheName = ObjectUtils.toString((Object)ContextHolder.getMemcachedName(), (String)"null"))) == null) {
                    sourceKeys = new ArrayList<String>();
                    sourceMap.put(cacheName, sourceKeys);
                }
                String sTempKey = CacheUtil.keyEncode(this.regionName, key);
                sourceKeys.add(sTempKey);
                if (!this.enableDelMark) continue;
                ArrayList<String> sourceDelMarkKeys = (ArrayList<String>)delMarkSourceMap.get(cacheName);
                if (sourceDelMarkKeys == null) {
                    sourceDelMarkKeys = new ArrayList<String>();
                    delMarkSourceMap.put(cacheName, sourceDelMarkKeys);
                }
                String sDelMarkKey = CacheUtil.delMarkKey(this.regionName, key);
                sourceDelMarkKeys.add(sDelMarkKey);
            }
            for (String sourceName : sourceMap.keySet()) {
                List sourceDelMarkKeys;
                ContextHolder.setCachdName("null".equals(sourceName) ? null : sourceName);
                List sourceKeys = (List)sourceMap.get(sourceName);
                if (!CollectionUtils.isNotEmpty((Collection)sourceKeys)) continue;
                String[] a = new String[sourceKeys.size()];
                a = sourceKeys.toArray(a);
                Object[] oResults = this.client.getMultiArray(a);
                for (int i = 0; i < oResults.length; ++i) {
                    Object mValue;
                    Object o = oResults[i];
                    String key = CacheUtil.keyDecode(this.regionName, a[i]);
                    if (null == o || null == key) continue;
                    Object object = mValue = this.isHasClassInfo() ? o : BindingHelper.getObjectFromByte((byte[])o, this.regionName);
                    if (this.enableLocalCache) {
                        this.getLocalCache().put(key, mValue);
                    }
                    resultMap.put(key, mValue);
                }
                if (!this.enableDelMark || !CollectionUtils.isNotEmpty((Collection)(sourceDelMarkKeys = (List)delMarkSourceMap.get(sourceName)))) continue;
                String[] a2 = new String[sourceDelMarkKeys.size()];
                a2 = sourceDelMarkKeys.toArray(a2);
                Object[] oResults2 = this.client.getMultiArray(a2);
                for (int i = 0; i < oResults2.length; ++i) {
                    Object o = oResults2[i];
                    String key = a2[i];
                    if (null == o || key == null) continue;
                    this.putDelKey(key);
                }
            }
        }
        Object[] lResult = new Object[keys.length];
        int size = keys.length;
        for (int i = 0; i < size; ++i) {
            String key;
            key = keys[i];
            lResult[i] = key == null ? null : resultMap.get(key);
        }
        this.exeAfterListener(keys, lResult, "get");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("gets time : " + DebugTimeUtils.getDistanceTime()));
        }
        return lResult;
    }

    @Override
    public boolean save(Map<String, Object> objectsMap) throws CacheException {
        CacheException lastException = null;
        if (MapUtils.isNotEmpty(objectsMap)) {
            Set<String> keySet = objectsMap.keySet();
            for (String key : keySet) {
                Object o = objectsMap.get(key);
                if (o == null) continue;
                try {
                    this.save(key, o);
                }
                catch (CacheException e) {
                    lastException = e;
                    e.printStackTrace(System.err);
                }
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        return true;
    }

    @Override
    public long decr(String key, long inc) throws CacheException {
        DebugTimeUtils.begTime();
        if (StringUtils.isEmpty((String)key)) {
            logger.info((Object)("region: " + StringUtils.defaultIfEmpty((String)this.regionName, (String)"") + " key is empty"));
            throw new CacheException("key is must have value");
        }
        long bResult = -1L;
        this.exeBeforeListener(key, inc, "decr");
        if (this.enableLocalCache) {
            logger.warn((Object)"don't suport local cache in incr method");
        }
        String sTempKey = CacheUtil.keyEncode(this.regionName, key);
        try {
            if (this.hasRoute) {
                this.routingService.setRoutingStrategy(this.regionName, key);
            }
            bResult = this.client.decr(sTempKey, inc);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        this.exeAfterListener(key, inc, "decr");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("put time : " + DebugTimeUtils.getDistanceTime()));
        }
        return bResult;
    }

    @Override
    public long incr(String key, long inc) throws CacheException {
        DebugTimeUtils.begTime();
        if (StringUtils.isEmpty((String)key)) {
            logger.info((Object)("region: " + StringUtils.defaultIfEmpty((String)this.regionName, (String)"") + " key is empty"));
            throw new CacheException("key is must have value");
        }
        long bResult = -1L;
        this.exeBeforeListener(key, inc, "incr");
        if (this.enableLocalCache) {
            logger.warn((Object)"don't suport local cache in incr method");
        }
        String sTempKey = CacheUtil.keyEncode(this.regionName, key);
        try {
            if (this.hasRoute) {
                this.routingService.setRoutingStrategy(this.regionName, key);
            }
            bResult = this.client.incr(sTempKey, inc);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        this.exeAfterListener(key, inc, "inc");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("decr time : " + DebugTimeUtils.getDistanceTime()));
        }
        return bResult;
    }

    @Override
    public boolean put(String key, Object value, Long seconds) throws CacheException {
        DebugTimeUtils.begTime();
        if (StringUtils.isEmpty((String)key) || value == null) {
            logger.info((Object)("region: " + StringUtils.defaultIfEmpty((String)this.regionName, (String)"") + " key is empty or value is null"));
            return false;
        }
        boolean bResult = false;
        this.exeBeforeListener(key, value, "put");
        String sTempKey = CacheUtil.keyEncode(this.regionName, key);
        try {
            if (this.hasRoute) {
                this.routingService.setRoutingStrategy(this.regionName, key);
            }
            Object mValue = this.isHasClassInfo() ? value : (Object)BindingHelper.getByteFromObject(value);
            bResult = this.client.set(sTempKey, mValue, seconds);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        this.exeAfterListener(key, value, "put");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("put time : " + DebugTimeUtils.getDistanceTime()));
        }
        return bResult;
    }
}

