/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.commons.code.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.VelocityEngine;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.ui.velocity.VelocityEngineUtils;

@Component(value="velocityGenerateFileUtil")
public class GenerateFileUtil {
    private static final Log log = LogFactory.getLog(GenerateFileUtil.class);
    @Autowired
    private VelocityEngine velocityEngine;

    public String generateFile(Map model, String template, String path, String fileName, Boolean isAppend) {
        String content = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)template, (Map)model);
        GenerateFileUtil.writeFile(path, fileName, isAppend, content);
        log.info((Object)(path + fileName + " created ==============succeess "));
        return fileName;
    }

    public String generateFileEncoding(Map model, String template, String path, String fileName, Boolean isAppend, String encoding) {
        String content = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)template, (Map)model);
        GenerateFileUtil.writeFileEncoding(path, fileName, isAppend, content, encoding);
        log.info((Object)(path + fileName + " created ==============succeess "));
        return fileName;
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public static void writeFile(String path, String name, boolean append, String content) {
        File myFilePath = new File(path + name);
        try {
            boolean e = new File(path).mkdirs();
            if (e) {
                System.out.println("Directories: " + path + " created");
            }
            if (!myFilePath.exists()) {
                myFilePath.createNewFile();
            }
            FileWriter resultFile = new FileWriter(myFilePath, append);
            PrintWriter myFile = new PrintWriter(resultFile);
            myFile.println(content);
            resultFile.close();
        }
        catch (Exception var8) {
            System.out.println("\u65b0\u5efa\u6587\u4ef6\u64cd\u4f5c\u51fa\u9519");
            var8.printStackTrace();
        }
    }

    public static void writeFileEncoding(String path, String name, boolean append, String content, String encoding) {
        File myFilePath = new File(path + name);
        try {
            boolean e = new File(path).mkdirs();
            if (e) {
                System.out.println("Directories: " + path + " created");
            }
            if (!myFilePath.exists()) {
                myFilePath.createNewFile();
            }
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(myFilePath), encoding));
            writer.write(content);
            writer.close();
        }
        catch (Exception var8) {
            System.out.println("\u65b0\u5efa\u6587\u4ef6\u64cd\u4f5c\u51fa\u9519");
            var8.printStackTrace();
        }
    }
}

