/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.commons.code.util;

import com.gemantic.commons.code.cmodel.CMold;
import com.gemantic.commons.code.cmodel.CProject;
import com.gemantic.commons.code.util.CMoldUtil;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CProjectUtil {
    private static final Log log = LogFactory.getLog(CProjectUtil.class);

    public static void init(CProject project) throws Exception {
        CProjectUtil.initBasic(project);
        List<CMold> cms = project.getMolds();
        for (CMold cm : cms) {
            CMoldUtil.initBasic(cm, project);
            CMoldUtil.initFields(cm);
            CMoldUtil.initModelSql(cm);
            CMoldUtil.initMethod(cm);
        }
        log.info((Object)" you will create project =================== ");
        log.info((Object)project);
        log.info((Object)" this project right ? ========================");
    }

    public static void initBasic(CProject project) {
        String[] s = project.getArtifactID().split("-");
        String keyWord = s[0] + "." + s[1];
        project.setKeyword(keyWord);
        String packageHome = project.getGroupID() + "." + keyWord;
        project.setPackageHome(packageHome);
        project.setServerPackage(packageHome + ".server");
        project.setServerPath(project.getPmain() + project.getServerPackage().replace(".", "\\"));
        String projectTag = s[0] + StringUtils.capitalize((String)s[1]);
        project.setComponent(StringUtils.capitalize((String)projectTag) + "Component");
        project.setDbDNS("db." + keyWord);
        project.setDbName(s[0] + "_" + s[1]);
        project.setCacheDNS("cache." + keyWord);
        project.setControllerPath(project.getPmain() + (packageHome + ".controller").replace(".", "\\"));
    }
}

