/*
 * Decompiled with CFR 0.152.
 */
package com.atlascopco.home.controller;

import com.alibaba.fastjson.JSONObject;
import com.atlascopco.home.util.DynamicUtil;
import com.atlascopco.home.util.MailUtil;
import com.atlascopco.model.Atlascopco;
import com.atlascopco.service.AtlascopcoService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AtlascopcoController {
    private static final Log log = LogFactory.getLog(AtlascopcoController.class);
    @Autowired
    private AtlascopcoService atlascopcoService;

    @ResponseBody
    @RequestMapping(value={"/a/sort/product/list"})
    public ModelMap getSortProduct(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size) {
        Integer type = 7;
        log.info((Object)("type is:" + type + ";;;" + page + size));
        if (page == null) {
            page = 1;
        }
        int start = 0;
        HashMap<String, Object> sortParams = new HashMap<String, Object>();
        List ids = null;
        List count = null;
        ArrayList sortProductList = new ArrayList();
        try {
            if (size == null) {
                size = Integer.MAX_VALUE;
            }
            if ((start = (page - 1) * size) < 0) {
                start = 0;
            }
            Map params = DynamicUtil.getList((Integer)type);
            count = this.atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            List sorts = this.atlascopcoService.getObjectsByIds(count);
            sortParams.put("type", 1);
            sortParams.put("status", 1);
            sortParams.put("@query", "id");
            sortParams.put("@table", "atlascopco");
            for (Atlascopco atlascopco : sorts) {
                sortParams.put("sort_id", atlascopco.getId());
                ids = this.atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, sortParams, Integer.valueOf(start), size);
                if (ids.isEmpty()) continue;
                ArrayList<Object> sort = new ArrayList<Object>();
                sort.add(atlascopco.getId());
                sort.add(atlascopco.getTitle());
                sort.add(this.atlascopcoService.getObjectsByIds(ids));
                sortProductList.add(sort);
            }
            model.addAttribute("code", (Object)0);
            model.addAttribute("page", (Object)page);
            model.addAttribute("size", (Object)size);
            model.addAttribute("total", (Object)count.size());
            model.addAttribute("sortProductList", sortProductList);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)"get  SortProductList  error  ");
            model.addAttribute("code", (Object)-100000);
        }
        return model;
    }

    @RequestMapping(value={"/a/sort/{sortId}/products"}, method={RequestMethod.GET})
    public String getProductBySortId(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable(value="sortId") Integer sortId, Integer page, Integer size) {
        int start;
        log.info((Object)("sortId is:" + sortId + ";;;" + page + size));
        if (page == null) {
            page = 1;
        }
        if (sortId == null) {
            model.addAttribute("code", (Object)-10000);
            return "common/fail";
        }
        if (size == null) {
            size = 6;
        }
        if ((start = (page - 1) * size) < 0) {
            start = 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        List ids = null;
        List productList = null;
        List count = null;
        try {
            params.put("sort_id", sortId);
            params.put("status", 1);
            params.put("@query", "id");
            params.put("@table", "atlascopco");
            params.put("@order", "num desc");
            ids = this.atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, Integer.valueOf(start), size);
            count = this.atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            productList = this.atlascopcoService.getObjectsByIds(ids);
            model.addAttribute("code", (Object)0);
            model.addAttribute("page", (Object)page);
            model.addAttribute("size", (Object)size);
            model.addAttribute("total", (Object)count.size());
            model.addAttribute("atlasList", (Object)productList);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)"get  productList  error  ");
            model.addAttribute("code", (Object)-100000);
        }
        return "atlascopco-service/atlascopco/json/atlascopcoListJson";
    }

    @RequestMapping(value={"/a/atlas"}, method={RequestMethod.GET})
    public String getProductList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer type, Integer page, Integer size) throws Exception {
        log.info((Object)("type is:" + type + ";;;" + page + size));
        if (page == null) {
            page = 1;
        }
        if (type == null) {
            model.addAttribute("code", (Object)-10000);
            return "common/fail";
        }
        int start = 0;
        Map params = null;
        List ids = null;
        List atlascopcoList = null;
        List count = null;
        try {
            if (type == 1) {
                if (size == null) {
                    size = 6;
                }
                if ((start = (page - 1) * size) < 0) {
                    start = 0;
                }
                params = DynamicUtil.getList((Integer)type);
                ids = this.atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, Integer.valueOf(start), size);
                count = this.atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            }
            if (type == 2) {
                if (size == null) {
                    size = Integer.MAX_VALUE;
                }
                params = DynamicUtil.getList((Integer)type);
                ids = this.atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, Integer.valueOf(start), size);
                count = this.atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            }
            if (type == 3) {
                if (size == null) {
                    size = 9;
                }
                if ((start = (page - 1) * size) < 0) {
                    start = 0;
                }
                params = DynamicUtil.getList((Integer)type);
                ids = this.atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, Integer.valueOf(start), size);
                count = this.atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            }
            if (type == 4 || type == 5 || type == 6) {
                if (size == null) {
                    size = 5;
                }
                if ((start = (page - 1) * size) < 0) {
                    start = 0;
                }
                params = DynamicUtil.getList((Integer)type);
                ids = this.atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, Integer.valueOf(start), size);
                count = this.atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            }
            if (type == 7) {
                if (size == null) {
                    size = Integer.MAX_VALUE;
                }
                if ((start = (page - 1) * size) < 0) {
                    start = 0;
                }
                params = DynamicUtil.getList((Integer)type);
                ids = this.atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, Integer.valueOf(start), size);
                count = this.atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            }
            atlascopcoList = this.atlascopcoService.getObjectsByIds(ids);
            log.info((Object)("atlascopcoList is: " + atlascopcoList.size()));
            model.addAttribute("code", (Object)0);
            model.addAttribute("page", (Object)page);
            model.addAttribute("size", (Object)size);
            model.addAttribute("total", (Object)count.size());
            model.addAttribute("atlasList", (Object)atlascopcoList);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)"get  atlascopcoList  error  ");
            model.addAttribute("code", (Object)-100000);
        }
        return "atlascopco-service/atlascopco/json/atlascopcoListJson";
    }

    @RequestMapping(value={"/a/atlas/{id}"}, method={RequestMethod.GET})
    public String getAtlascopcoJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        log.info((Object)("get data : id= " + id));
        try {
            Atlascopco atlascopco = this.atlascopcoService.getObjectById(id);
            log.info((Object)("get atlascopco data is " + atlascopco));
            model.addAttribute("code", (Object)0);
            model.addAttribute("atlascopco", (Object)atlascopco);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("get atlascopco error,id is  " + id));
            model.addAttribute("code", (Object)-100000);
            return "common/fail";
        }
        return "/atlascopco-service/atlascopco/json/atlascopcoDetailJson";
    }

    @RequestMapping(value={"/a/email"}, method={RequestMethod.POST})
    public String getAtlascopcoJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, String name, String phone, String message) throws Exception {
        log.info((Object)("get name is:" + name + "\n phone is :" + phone + "\n message :" + message));
        if (StringUtils.isBlank((CharSequence)name)) {
            model.addAttribute("code", (Object)-3001);
        }
        if (StringUtils.isBlank((CharSequence)phone)) {
            model.addAttribute("code", (Object)-3002);
        }
        if (StringUtils.isBlank((CharSequence)message)) {
            model.addAttribute("code", (Object)-3003);
        }
        try {
            String mail = "\u59d3\u540d:" + name + "; \u8054\u7cfb\u65b9\u5f0f\uff1a" + phone + "; \u7559\u8a00\uff1a" + message;
            log.info((Object)("get mail is: " + mail));
            String result = MailUtil.sentMail((String)mail);
            if (result == null) {
                model.addAttribute("code", (Object)-8010);
                return "common/fail";
            }
            String statusCode = JSONObject.parseObject((String)result).getString("statusCode");
            String message1 = JSONObject.parseObject((String)result).getString("message");
            model.addAttribute("code", (Object)statusCode);
            model.addAttribute("message", (Object)message1);
            log.info((Object)("get statusCode is: " + statusCode + ";  get message is : " + message1));
            return "common/mail";
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)"get  atlascopcoList  error  ");
            model.addAttribute("code", (Object)-100000);
            return "common/success";
        }
    }
}

