package com.atlascopco.home.util;

import com.atlascopco.home.constant.ConstantItem;
import com.ptteng.common.dao.util.SQLUtil;
import com.qding.common.util.DataUtils;
import org.apache.log4j.Logger;

import java.util.HashMap;
import java.util.Map;


/**
 * @author CK
 */
public class DynamicUtil {
    private static final Logger log = Logger.getLogger(DynamicUtil.class);
    private static Map<String, Object> applyManageList;


    /**
     * 列表搜索
     *
     * @param type
     * @return
     */
    public static Map<String, Object> getList(Integer type) {
        Map<String, Object> params = new HashMap<String, Object>();

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", type);
        }

        // 产品分类type=7的时候 status字段为空
        if (type != ConstantItem.SERVEN) {
            params.put("status",1);
        }

        params.put("@query", "id");
        params.put("@table", "atlascopco");

        //添加产品排序 params.put("@order", "num desc");
        if (type == ConstantItem.ONE){
            params.put("@order", "num desc");
        }else{
            params.put("@order", "update_at desc");
        }

        log.info(SQLUtil.convert2Sql(params, 0, Integer.MAX_VALUE));

        return params;
    }


}
