package com.atlascopco.home.controller;

import com.alibaba.fastjson.JSONObject;
import com.atlascopco.home.constant.ConstantItem;
import com.atlascopco.home.util.DynamicUtil;
import com.atlascopco.home.util.MailUtil;
import com.atlascopco.model.Atlascopco;
import com.atlascopco.service.AtlascopcoService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * Atlascopco  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class AtlascopcoController {
    private static final Log log = LogFactory.getLog(AtlascopcoController.class);


    @Autowired
    private AtlascopcoService atlascopcoService;



    /**
     *
     * @param:
     * @return:
     * @auther: Zhang Qiang
     * @date: 2018/9/10 16:03
     * @info: 搜索所有分类和产品
     *
     */
    @ResponseBody
    @RequestMapping(value = "/a/sort/product/list")
    public ModelMap getSortProduct(HttpServletRequest request, HttpServletResponse response, ModelMap model,Integer page, Integer size){

        //type为7，搜索为分类列表
        Integer type = ConstantItem.SERVEN;

        log.info("type is:" + type + ";;;" + page + size);

        if (page == null) page = 1;
        int start = 0;

        Map<String, Object> params ;
        Map<String, Object> sortParams = new HashMap<>();
        List<Long> ids = null;
        List<Long> count = null;
        List sortProductList = new ArrayList<>();


        try {

            if (size == null) {
                size = Integer.MAX_VALUE;
            }
            start = (page - 1) * size;
            if (start < 0) {
                start = 0;
            }

            //获取分类ids
            params = DynamicUtil.getList(type);
            count = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, 0, Integer.MAX_VALUE);


            //通过ids 获取分类列表
            List<Atlascopco> sorts = atlascopcoService.getObjectsByIds(count);

            sortParams.put("type",1);
            sortParams.put("status",1);
            sortParams.put("@query", "id");
            sortParams.put("@table", "atlascopco");

            //循环 查询每个分类下所有产品，并添加list
            for(Atlascopco atlascopco : sorts){

                //添加检索条件 sort_id
                sortParams.put("sort_id",atlascopco.getId());

                //查询分类下所有产品ids，无产品则不展示.返回数据类型：list[[id,title,[products[]]],[……],[……],[……]]
                ids = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, sortParams, start, size);

                //添加数据   id title [productList]
                if (!ids.isEmpty() ) {
                    List sort = new ArrayList();
                    sort.add(atlascopco.getId());
                    sort.add(atlascopco.getTitle());
                    sort.add(atlascopcoService.getObjectsByIds(ids));
                    sortProductList.add(sort);
                }

            }


            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", count.size());
            model.addAttribute("sortProductList", sortProductList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get  SortProductList  error  ");
            model.addAttribute("code", -100000);
        }

        return model;
    }



    /**
     * @param: [request, response, model, sortId, page, size]
     * @return: java.lang.String
     * @auther: Zhang Qiang
     * @date: 2018/9/10 20:00
     * @info: 获取分类下所有产品 sortId 分类id
     *
     */
    @RequestMapping(value = "/a/sort/{sortId}/products",method = RequestMethod.GET)
    public String getProductBySortId(HttpServletRequest request, HttpServletResponse response, ModelMap model,@PathVariable(value = "sortId") Integer sortId ,Integer page, Integer size){

        log.info("sortId is:" + sortId + ";;;" + page + size);

        if (page == null) {
            page = 1;
        }
        //判断sortId是否为空
        if (sortId == null) {
            model.addAttribute("code", -10000);
            return "common/fail";
        }

        if (size == null) {
            size = 6;
        }

        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        Map<String, Object> params = new HashMap<>();
        List<Long> ids = null;
        List<Atlascopco> productList = null;
        List<Long> count =null;

        try {

            params.put("sort_id",sortId);
            params.put("status",1);
            params.put("@query","id");
            params.put("@table", "atlascopco");
            params.put("@order", "num desc");
            ids = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, start, size);
            count = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, 0, Integer.MAX_VALUE);
            productList = atlascopcoService.getObjectsByIds(ids);


            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", count.size());
            model.addAttribute("atlasList", productList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get  productList  error  ");
            model.addAttribute("code", -100000);

        }

        return "atlascopco-service/atlascopco/json/atlascopcoListJson";
    }




    /**
     * 1、查看列表
     *
     * @param request
     * @param response
     * @param model
     * @param type
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/atlas", method = RequestMethod.GET)
    public String getProductList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer type, Integer page, Integer size) throws Exception {

        log.info("type is:" + type + ";;;" + page + size);

        if (page == null) {
            page = 1;
        }
        //判断type是否为空
        if (type == null) {
            model.addAttribute("code", -10000);
            return "common/fail";
        }
        int start = 0;

        Map<String, Object> params = null;
        List<Long> ids = null;
        List<Atlascopco> atlascopcoList = null;
        List<Long> count =null;

        try {
            //当type为1时，表示搜索的结果为产品列表
            if (type == ConstantItem.ONE) {

                if (size == null) {
                    size = 6;
                }
                start = (page - 1) * size;
                if (start < 0) {
                    start = 0;
                }
                params = DynamicUtil.getList(type);
                ids = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, start, size);
                count = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, 0, Integer.MAX_VALUE);
            }

            //当type为2时，搜索为招聘信息列表，获取所有
            if (type == ConstantItem.TWO) {
                if (size == null) {
                    size = Integer.MAX_VALUE;
                }

                params = DynamicUtil.getList(type);
                ids = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, start, size);
                count = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, 0, Integer.MAX_VALUE);

            }

            //当type为3时，搜索为售后服务列表
            if (type == ConstantItem.THREE) {
                if (size == null) {
                    size = 9;
                }
                start = (page - 1) * size;
                if (start < 0) {
                    start = 0;
                }
                params = DynamicUtil.getList(type);
                ids = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, start, size);
                count = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, 0, Integer.MAX_VALUE);
            }

            //当type为 4 时搜索为客户案例列表，为 5 时搜索为新闻案例列表，为 6 时搜索为banner列表
            if (type == ConstantItem.FOUR || type == ConstantItem.FIVE || type == ConstantItem.SIX) {
                if (size == null) {
                    size = 5;
                }
                start = (page - 1) * size;
                if (start < 0) {
                    start = 0;
                }
                params = DynamicUtil.getList(type);
                ids = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, start, size);
                count = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, 0, Integer.MAX_VALUE);
            }


            //当type为7时，搜索为分类列表
            if (type == ConstantItem.SERVEN) {
                if (size == null) {
                    size = Integer.MAX_VALUE;
                }
                start = (page - 1) * size;
                if (start < 0) {
                    start = 0;
                }
                params = DynamicUtil.getList(type);
                ids = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, start, size);
                count = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, 0, Integer.MAX_VALUE);
            }

            //通过ids获取列表
            atlascopcoList = atlascopcoService.getObjectsByIds(ids);
            log.info("atlascopcoList is: " + atlascopcoList.size());

            //对获取的列表进行判空
//            if (atlascopcoList == null) {
//                model.addAttribute("code", 0);
//                model.addAttribute("page", page);
//                model.addAttribute("size", size);
//                model.addAttribute("total", count.size());
//                return "atlascopco-service/atlascopco/json/atlascopcoListJson";
//            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", count.size());
            model.addAttribute("atlasList", atlascopcoList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get  atlascopcoList  error  ");
            model.addAttribute("code", -100000);
        }

        return "atlascopco-service/atlascopco/json/atlascopcoListJson";
    }


    /**
     * 2、获取详情
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/atlas/{id}", method = RequestMethod.GET)
    public String getAtlascopcoJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        log.info("get data : id= " + id);

        try {
            Atlascopco atlascopco = atlascopcoService.getObjectById(id);
            log.info("get atlascopco data is " + atlascopco);

            model.addAttribute("code", 0);
            model.addAttribute("atlascopco", atlascopco);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get atlascopco error,id is  " + id);
            model.addAttribute("code", -100000);

            return "common/fail";
        }

        return "/atlascopco-service/atlascopco/json/atlascopcoDetailJson";
    }


    /**
     *  3.发送邮件
     * @param request
     * @param response
     * @param model
     * @param name
     * @param phone
     * @param message
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/email", method = RequestMethod.POST)
    public String getAtlascopcoJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, String name, String phone, String message) throws Exception {

        log.info("get name is:" + name + "\n phone is :" + phone + "\n message :" + message);

        if (StringUtils.isBlank(name)){
            model.addAttribute("code",-3001);
        }
        if (StringUtils.isBlank(phone)){
            model.addAttribute("code",-3002);
        }
        if (StringUtils.isBlank(message)){
            model.addAttribute("code",-3003);
        }


        try {
            String mail = "姓名:"+name +
                    "; 联系方式："+phone+
                    "; 留言："+message;
            log.info("get mail is: "+ mail );

            String result = MailUtil.sentMail(mail);
            if (result == null) {
                model.addAttribute("code",-8010);
                return "common/fail";
            }

            String statusCode = JSONObject.parseObject(result).getString("statusCode");
            String message1 = JSONObject.parseObject(result).getString("message");

            model.addAttribute("code",statusCode);
            model.addAttribute("message",message1);
            log.info("get statusCode is: "+ statusCode+ ";  get message is : "+ message1);
            return "common/mail";

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get  atlascopcoList  error  ");
            model.addAttribute("code", -100000);
        }
        return "common/success";

    }
}

