/*
 * Decompiled with CFR 0.152.
 */
package com.atlascopco.admin.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.storage.util.ImgStorageUtil;
import com.qding.common.util.FileUtil;
import java.io.File;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class SystemController {
    private static final Log log = LogFactory.getLog(SystemController.class);
    @Autowired
    private ImgStorageUtil imgStorageUtil;

    @RequestMapping(value={"/a/u/img/{module}"}, method={RequestMethod.POST})
    public String uploadFile(HttpServletRequest request, HttpServletResponse response, ModelMap model, @RequestParam MultipartFile file, @PathVariable String module) {
        log.info((Object)("upload module is " + module));
        if (StringUtils.isBlank((String)module)) {
            log.info((Object)"type is null");
        }
        log.info((Object)file.getOriginalFilename());
        try {
            String ext = FileUtil.getFileExtension((String)file.getOriginalFilename());
            String fileName = UUID.randomUUID().toString() + "." + ext;
            String filePath = "/data/img/" + module + "/" + fileName;
            String dirPath = "/data/img/" + module;
            File dir = new File("/data/img/atlas/" + module);
            if (dir.exists()) {
                log.info((Object)("\u521b\u5efa\u76ee\u5f55" + dirPath + "\u5931\u8d25\uff0c\u76ee\u6807\u76ee\u5f55\u5df2\u7ecf\u5b58\u5728"));
            } else if (dir.mkdirs()) {
                log.info((Object)("\u521b\u5efa\u76ee\u5f55" + dirPath + "\u6210\u529f\uff01"));
            } else {
                log.info((Object)("\u521b\u5efa\u76ee\u5f55" + dirPath + "\u5931\u8d25\uff01"));
            }
            File tempFile = new File(filePath);
            file.transferTo(tempFile);
            String url = this.imgStorageUtil.imgStorage(null, "img/" + module + "/" + fileName, filePath);
            log.info((Object)(module + " upload success ,and file name is " + fileName + "temp path is " + filePath + " access url is " + url));
            tempFile.delete();
            model.addAttribute("url", (Object)url);
            model.addAttribute("code", (Object)"0");
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            model.addAttribute("code", (Object)-100000);
        }
        return "common/img";
    }

    @RequestMapping(value={"/a/mail"}, method={RequestMethod.POST})
    public String sendMailVerify(HttpServletRequest request, HttpServletResponse response, ModelMap model, String name, String phone, String message) throws ServiceException, ServiceDaoException {
        log.info((Object)(" want send mail  content  is:" + name + phone + message));
        try {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)name)) {
                log.info((Object)(" want send of name " + name + "is  null"));
                model.addAttribute("code", (Object)-2022);
                return "/common/fail";
            }
            log.info((Object)"mail address verify ");
            Pattern p = Pattern.compile("^([a-zA-Z0-9_-])+@([a-zA-Z0-9_-])+(\\.([a-zA-Z0-9_-])+)+$");
            Matcher m = p.matcher("chengkai@jnshu.com");
            boolean result = m.matches();
            log.info((Object)("mail address verify result : " + result));
            if (!result) {
                log.info((Object)"mail address verify fail");
                model.addAttribute("code", (Object)-2023);
                return "/common/success";
            }
            log.info((Object)"mail address verify OK");
            model.addAttribute("code", (Object)0);
        }
        catch (Exception t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)" send message error of type ");
            model.addAttribute("code", (Object)-1);
        }
        return "/common/success";
    }
}

