/*
 * Decompiled with CFR 0.152.
 */
package com.atlascopco.admin.controller;

import com.atlascopco.model.RoleModule;
import com.atlascopco.service.RoleModuleService;
import com.qding.common.util.DataUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class RoleModuleController {
    private static final Log log = LogFactory.getLog(RoleModuleController.class);
    @Autowired
    private RoleModuleService roleModuleService;

    @RequestMapping(value={"/c/roleModule"}, method={RequestMethod.GET})
    public String getroleModuleList(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
        log.info((Object)"/roleModule  to /roleModule/view/roleModuleList");
        return "/score-home-service/roleModule/view/roleModuleList";
    }

    @RequestMapping(value={"/c/roleModule/{id}"}, method={RequestMethod.GET})
    public String getRoleModule(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        log.info((Object)("/roleModule/" + id + "  to /roleModule/view/roleModuleDeail"));
        if (null != id) {
            model.addAttribute("id", (Object)id);
        } else {
            model.addAttribute("id", (Object)0);
        }
        return "/score-home-service/roleModule/view/roleModuleDetail";
    }

    @RequestMapping(value={"/a/roleModule/{id}"}, method={RequestMethod.GET})
    public String getRoleModuleJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        if (DataUtils.isNullOrEmpty((Object)id)) {
            log.info((Object)"get id is null\uff01");
            model.addAttribute("code", (Object)-1000);
            return "common/fail";
        }
        log.info((Object)("get data : id= " + id));
        try {
            RoleModule roleModule = this.roleModuleService.getObjectById(id);
            log.info((Object)("get roleModule data is " + roleModule));
            model.addAttribute("code", (Object)0);
            model.addAttribute("roleModule", (Object)roleModule);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("get roleModule error,id is  " + id));
            model.addAttribute("code", (Object)-100000);
        }
        return "/score-home-service/roleModule/json/roleModuleDetailJson";
    }

    @RequestMapping(value={"/a/roleModule"}, method={RequestMethod.POST})
    public String addRoleModuleJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, RoleModule roleModule) throws Exception {
        if (DataUtils.isNullOrEmpty((Object)roleModule)) {
            log.info((Object)"get roleModule is null\uff01");
            model.addAttribute("code", (Object)-1000);
            return "common/fail";
        }
        log.info((Object)("update roleModule : roleModule= " + roleModule));
        try {
            roleModule.setId(null);
            this.roleModuleService.insert(roleModule);
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)"add roleModule error ");
            model.addAttribute("code", (Object)-6002);
        }
        return "/data/json";
    }

    @RequestMapping(value={"/a/roleModule/{id}"}, method={RequestMethod.DELETE})
    public String deleteRoleModuleJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        if (DataUtils.isNullOrEmpty((Object)id)) {
            log.info((Object)"get id is null\uff01");
            model.addAttribute("code", (Object)-1000);
            return "common/fail";
        }
        log.info((Object)("delete roleModule : id= " + id));
        try {
            this.roleModuleService.delete(id);
            log.info((Object)"add roleModule success");
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("delete roleModule error,id is  " + id));
            model.addAttribute("code", (Object)-6004);
        }
        return "/data/json";
    }

    @RequestMapping(value={"/a/multi/roleModule"}, method={RequestMethod.GET})
    public String getMultiRoleModuleJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long[] ids) throws Exception {
        List<Object> idList = new ArrayList();
        if (ids != null) {
            idList = Arrays.asList(ids);
        }
        try {
            List roleModuleList = this.roleModuleService.getObjectsByIds(idList);
            log.info((Object)("get  roleModule data is " + roleModuleList));
            model.addAttribute("code", (Object)0);
            model.addAttribute("total", (Object)roleModuleList.size());
            model.addAttribute("roleModuleList", (Object)roleModuleList);
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("get roleModule error,id is  " + idList));
            model.addAttribute("code", (Object)-100000);
        }
        return "/score-home-service/roleModule/json/roleModuleListJson";
    }
}

