/*
 * Decompiled with CFR 0.152.
 */
package com.atlascopco.admin.controller;

import com.atlascopco.admin.util.RoleUtil;
import com.atlascopco.model.Role;
import com.atlascopco.model.RoleModule;
import com.atlascopco.service.ManagerService;
import com.atlascopco.service.ModuleService;
import com.atlascopco.service.RoleModuleService;
import com.atlascopco.service.RoleService;
import com.qding.common.util.http.cookie.CookieUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class RoleController {
    private static final Log log = LogFactory.getLog(RoleController.class);
    @Autowired
    private RoleService roleService;
    @Autowired
    private ManagerService managerService;
    @Autowired
    private RoleModuleService roleModuleService;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private CookieUtil cookieUtil;

    @RequestMapping(value={"/a/u/role/list"}, method={RequestMethod.GET})
    public String getRoleJsonList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size) throws Exception {
        int start;
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 50;
        }
        if ((start = (page - 1) * size) < 0) {
            start = 0;
        }
        log.info((Object)("pageList : page= " + start + " , size=" + size));
        try {
            Boolean next = false;
            size = size + 1;
            List ids = this.roleService.getRoleIds(Integer.valueOf(start), size);
            List totalids = this.roleService.getRoleIds(Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("get role size is " + ids.size()));
            if (ids != null && ids.size() > 0) {
                if (size.equals(ids.size())) {
                    next = true;
                    log.info((Object)("ss  " + ids.subList(0, size - 1)));
                    model.addAttribute("ids", ids.subList(0, size - 1));
                } else {
                    log.info((Object)("ss  " + ids.subList(0, ids.size())));
                    model.addAttribute("ids", ids.subList(0, ids.size()));
                }
                int totalCnt = totalids.size();
                model.addAttribute("total", (Object)totalCnt);
            } else {
                model.addAttribute("ids", (Object)ids);
                model.addAttribute("total", (Object)0);
            }
            log.info((Object)("next is " + next));
            model.addAttribute("code", (Object)0);
            model.addAttribute("size", (Object)(size - 1));
            model.addAttribute("next", (Object)next);
            model.addAttribute("page", (Object)page);
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("get role list error,page is  " + start + " , size " + size));
            model.addAttribute("code", (Object)-100000);
        }
        return "admin/role/json/roleIdListJson";
    }

    @RequestMapping(value={"/a/u/role/{id}"}, method={RequestMethod.PUT})
    public String updateRoleJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id, @RequestBody Role role) throws Exception {
        log.info((Object)("update role : role= " + role));
        try {
            if (role == null) {
                log.info((Object)"role  is  null ");
                model.addAttribute("code", (Object)-1004);
                return "/common/json";
            }
            if (StringUtils.isBlank((CharSequence)role.getName())) {
                log.info((Object)"role name  is  null ");
                model.addAttribute("code", (Object)-1004);
                return "/common/json";
            }
            if (this.roleService.getObjectById(role.getId()) == null) {
                model.addAttribute("code", (Object)-7001);
                return "/common/json";
            }
            Role r = this.roleService.getObjectById(id);
            String userId = this.cookieUtil.getKeyIdentity(request, "userId");
            r.setName(role.getName());
            role = RoleUtil.convertPermission2String((Role)role);
            r.setPermissions(role.getPermissions());
            r.setPermissionsSet(role.getPermissionsSet());
            r.setUpdateBy(Long.valueOf(userId));
            this.roleService.update(r);
            List roleModuleIds = this.roleModuleService.getRoleModuleIdsByRid(r.getId(), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            this.roleModuleService.deleteList(RoleModule.class, roleModuleIds);
            ArrayList<RoleModule> roleModules = new ArrayList<RoleModule>();
            log.info((Object)("get permission is " + r.getPermissionsSet()));
            for (Long moduleId : r.getPermissionsSet().keySet()) {
                if (moduleId == null || "".equals(moduleId)) continue;
                RoleModule roleModule = new RoleModule();
                roleModule.setCreateBy(Long.valueOf(userId));
                roleModule.setUpdateBy(Long.valueOf(userId));
                roleModule.setRoleId(role.getId());
                roleModule.setModuleId(moduleId);
                roleModules.add(roleModule);
            }
            this.roleModuleService.insertList(roleModules);
            model.addAttribute("code", (Object)0);
            model.addAttribute("role", (Object)role);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("update role error,id is  " + role.getId()));
            model.addAttribute("code", (Object)-100000);
        }
        return "admin/role/json/roleDetailJson";
    }

    @RequestMapping(value={"/a/u/role/{rid}"}, method={RequestMethod.GET})
    public String getRoleJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long rid) throws Exception {
        log.info((Object)("get  role : role id = " + rid));
        try {
            ArrayList mids = new ArrayList();
            model.addAttribute("rid", (Object)rid);
            Role role = this.roleService.getObjectById(rid);
            log.info((Object)("get json is: " + role.getPermissions()));
            log.info((Object)("get json is: " + role.getPermissionsSet()));
            if (role == null) {
                model.addAttribute("code", (Object)-7001);
                return "/common/json";
            }
            role = RoleUtil.convertString2permission((Role)role);
            model.addAttribute("role", (Object)role);
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("update role error,id is  " + rid));
            model.addAttribute("code", (Object)-100000);
        }
        return "admin/role/json/roleDetailJson";
    }

    @RequestMapping(value={"/a/u/role/stop/{id}"}, method={RequestMethod.PUT})
    public String stopRole(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id, @RequestBody Role role) throws Exception {
        log.info((Object)("update role : role= " + role));
        try {
            List managerIds = this.managerService.getManagerIdsByRoleIDAndStatus(role.getId(), "using", null, null);
            if (managerIds.size() > 0) {
                log.info((Object)"manager with status using has this role");
                model.addAttribute("code", (Object)-7005);
            } else {
                String userId = this.cookieUtil.getKeyIdentity(request, "userId");
                role.setUpdateBy(Long.valueOf(userId));
                this.roleService.update(role);
                model.addAttribute("code", (Object)0);
                model.addAttribute("role", (Object)role);
            }
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("update role error,id is  " + role.getId()));
            model.addAttribute("code", (Object)-100000);
        }
        return "/common/json";
    }

    @RequestMapping(value={"/a/u/role"}, method={RequestMethod.POST})
    public String addRoleJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @RequestBody Role role) throws Exception {
        log.info((Object)("add role : name= " + role.getName() + " role modules " + role.getPermissionsSet()));
        try {
            if (role == null) {
                log.info((Object)"role  is  null ");
                model.addAttribute("code", (Object)-1004);
                return "/common/json";
            }
            role = RoleUtil.convertPermission2String((Role)role);
            Long uid = Long.valueOf(this.cookieUtil.getKeyIdentity(request, "userId"));
            role.setCreateBy(uid);
            role.setUpdateBy(uid);
            role.setId(null);
            role.setStatus("using");
            Long roleId = this.roleService.insert(role);
            ArrayList<RoleModule> roleModules = new ArrayList<RoleModule>();
            for (Long moduleId : role.getPermissionsSet().keySet()) {
                if (null == moduleId || "".equals(moduleId)) continue;
                RoleModule roleModule = new RoleModule();
                roleModule.setCreateBy(uid);
                roleModule.setUpdateBy(uid);
                roleModule.setRoleId(roleId);
                roleModule.setModuleId(Long.valueOf(moduleId));
                roleModules.add(roleModule);
            }
            this.roleModuleService.insertList(roleModules);
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)"add role error ");
            model.addAttribute("code", (Object)-100000);
        }
        return "/common/json";
    }

    @RequestMapping(value={"/a/u/role/{rid}"}, method={RequestMethod.DELETE})
    public String deleteRoleJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long rid) throws Exception {
        log.info((Object)("delete role : id= " + rid));
        try {
            if (rid == null) {
                model.addAttribute("code", (Object)-1004);
                return "/common/json";
            }
            List managerIds = this.managerService.getManagerIdsByRoleID(rid, null, null);
            if (managerIds.size() > 0) {
                log.info((Object)"manager has this role");
                model.addAttribute("code", (Object)-7004);
            } else if (this.roleService.getObjectById(rid) == null) {
                model.addAttribute("code", (Object)-7001);
            } else {
                List roleModuleIds = this.roleModuleService.getRoleModuleIdsByRid(rid, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                log.info((Object)(" roleMudleids  is  " + roleModuleIds));
                if (roleModuleIds != null && roleModuleIds.size() > 0) {
                    for (Long roleModuleId : roleModuleIds) {
                        this.roleModuleService.delete(roleModuleId);
                    }
                }
                this.roleService.delete(rid);
                log.info((Object)"delete role success");
                model.addAttribute("code", (Object)0);
            }
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("delete role error,id is  " + rid));
            model.addAttribute("code", (Object)-100000);
        }
        return "/common/json";
    }

    @RequestMapping(value={"/a/u/multi/role"}, method={RequestMethod.GET})
    public String getMultiRoleJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long[] ids) throws Exception {
        log.info((Object)("get role rid " + ids));
        List<Object> idList = new ArrayList();
        if (ids == null || ids.length <= 0) {
            model.addAttribute("code", (Object)0);
            model.addAttribute("size", (Object)10);
            model.addAttribute("total", (Object)0);
        } else {
            idList = Arrays.asList(ids);
        }
        try {
            if (idList == null || idList.size() <= 0) {
                model.addAttribute("code", (Object)0);
                model.addAttribute("size", (Object)10);
                model.addAttribute("total", (Object)0);
            } else {
                List roleList = this.roleService.getObjectsByIds(idList);
                log.info((Object)("get roleList size is " + roleList.size()));
                if (roleList != null && roleList.size() > 0) {
                    model.addAttribute("code", (Object)0);
                    model.addAttribute("size", (Object)10);
                    model.addAttribute("total", (Object)roleList.size());
                    model.addAttribute("roleList", (Object)roleList);
                } else {
                    for (Role r : roleList) {
                        r = RoleUtil.convertString2permission((Role)r);
                    }
                    model.addAttribute("code", (Object)0);
                    model.addAttribute("size", (Object)10);
                    model.addAttribute("total", (Object)0);
                    model.addAttribute("roleList", (Object)roleList);
                }
            }
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("get role error,id is  " + Arrays.toString((Object[])ids)));
            model.addAttribute("code", (Object)-100000);
        }
        return "admin/role/json/roleListJson";
    }
}

