/*
 * Decompiled with CFR 0.152.
 */
package com.atlascopco.admin.controller;

import com.atlascopco.model.Module;
import com.atlascopco.service.ModuleService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class ModuleController {
    private static final Log log = LogFactory.getLog(ModuleController.class);
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private CookieUtil cookieUtil;

    @RequestMapping(value={"/a/u/module"}, method={RequestMethod.POST})
    public String addModuleJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Module module) throws Exception {
        log.info((Object)("insert module is " + module));
        if (DataUtils.isNullOrEmpty((Object)module.getName())) {
            log.error((Object)"\u5fc5\u586b\u53c2\u6570\u6709\u8bef\u6216\u4e3a\u7a7a\uff01");
            model.addAttribute("code", (Object)-1000);
            return "common/fail";
        }
        Long adminId = Long.valueOf(this.cookieUtil.getKeyIdentity(request, "userId"));
        try {
            module.setCreateBy(adminId);
            module.setUpdateBy(adminId);
            Long id = this.moduleService.insert(module);
            log.info((Object)("insert module is : " + id));
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)"add module error ");
            model.addAttribute("code", (Object)-100000);
        }
        return "/common/json";
    }

    @RequestMapping(value={"/a/u/module/{id}"}, method={RequestMethod.DELETE})
    public String deleteModuleJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        log.info((Object)("delete module  id : " + id));
        try {
            boolean result = this.moduleService.delete(id);
            log.info((Object)("delete module id result is :" + result));
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("delete module error,id is  " + id));
            model.addAttribute("code", (Object)-6004);
        }
        return "/common/json";
    }

    @RequestMapping(value={"/a/u/module/{id}"}, method={RequestMethod.PUT})
    public String updateModuleJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @RequestBody Module module, @PathVariable Long id) throws Exception {
        log.info((Object)("update module is : " + module));
        if (DataUtils.isNullOrEmpty((Object)module.getName())) {
            log.error((Object)"\u5fc5\u586b\u53c2\u6570\u6709\u8bef\u6216\u4e3a\u7a7a\uff01");
            model.addAttribute("code", (Object)-1000);
            return "common/fail";
        }
        Long adminId = Long.valueOf(this.cookieUtil.getKeyIdentity(request, "userId"));
        try {
            Module module1 = this.moduleService.getObjectById(id);
            log.info((Object)("get module1 is :" + module1));
            module.setCreateAt(module1.getCreateAt());
            module.setCreateBy(module1.getCreateBy());
            module.setUpdateBy(adminId);
            module.setId(module1.getId());
            boolean result = this.moduleService.update(module);
            log.info((Object)("update module result is : " + result));
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("update module error,id is  " + module.getId()));
            model.addAttribute("code", (Object)-100000);
        }
        return "/common/json";
    }

    @RequestMapping(value={"/a/u/module/list"}, method={RequestMethod.GET})
    public String getModuleList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size) throws Exception {
        int start;
        log.info((Object)("get param = page is : " + page + " size is : " + size));
        if (page == null || page <= 0) {
            page = 1;
        }
        if (size == null || size <= 0) {
            size = 10;
        }
        if ((start = (page - 1) * size) < 0) {
            start = 0;
        }
        List moduleIdList = null;
        List count = null;
        List moduleList = null;
        try {
            moduleIdList = this.moduleService.getModuleIds(Integer.valueOf(start), size);
            log.info((Object)("get moduleIdList is : " + moduleIdList));
            count = this.moduleService.getModuleIds(Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("get count is : " + count));
            moduleList = this.moduleService.getObjectsByIds(moduleIdList);
            log.info((Object)("get  moduleList is : " + moduleList));
            model.addAttribute("code", (Object)0);
            model.addAttribute("total", (Object)count.size());
            model.addAttribute("page", (Object)page);
            model.addAttribute("size", (Object)size);
            model.addAttribute("moduleList", (Object)moduleList);
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("get module error,id is  " + moduleIdList));
            model.addAttribute("code", (Object)-100000);
        }
        return "/admin/module/json/moduleListJson";
    }

    @RequestMapping(value={"/a/u/module/{id}"}, method={RequestMethod.GET})
    public String getModuleJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        log.info((Object)("get module id is : " + id));
        try {
            Module module = this.moduleService.getObjectById(id);
            log.info((Object)("get module is : " + module));
            model.addAttribute("code", (Object)0);
            model.addAttribute("module", (Object)module);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("get module error,id is  " + id));
            model.addAttribute("code", (Object)-100000);
        }
        return "/admin/module/json/moduleDetailJson";
    }

    @RequestMapping(value={"/a/u/multi/module"}, method={RequestMethod.GET})
    public String getMultiModuleJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long[] ids) throws Exception {
        log.info((Object)("get module mid " + ids));
        List<Object> idList = new ArrayList();
        if (ids == null || ids.length <= 0) {
            model.addAttribute("code", (Object)0);
            model.addAttribute("total", (Object)0);
            model.addAttribute("size", (Object)10);
        } else {
            idList = Arrays.asList(ids);
        }
        try {
            if (idList.size() == 0 || idList.size() <= 0) {
                model.addAttribute("code", (Object)0);
                model.addAttribute("total", (Object)0);
                model.addAttribute("size", (Object)10);
            } else {
                List moduleList = this.moduleService.getObjectsByIds(idList);
                log.info((Object)("get moduleList data is " + moduleList.size()));
                if (moduleList.size() != 0 && moduleList.size() > 0) {
                    int totalPage = 0;
                    int totalCnt = moduleList.size();
                    if (totalCnt > 0) {
                        totalPage = totalCnt / 10 + 1;
                    }
                    model.addAttribute("code", (Object)0);
                    model.addAttribute("total", (Object)moduleList.size());
                    model.addAttribute("moduleList", (Object)moduleList);
                } else {
                    model.addAttribute("code", (Object)0);
                    model.addAttribute("total", (Object)0);
                    model.addAttribute("moduleList", (Object)moduleList);
                }
            }
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("get module error,id is  " + Arrays.toString((Object[])ids)));
            model.addAttribute("code", (Object)-100000);
        }
        return "/admin/module/json/moduleListJson";
    }

    @RequestMapping(value={"/a/u/module/"}, method={RequestMethod.GET})
    public String getModuleIdsByTypeJsonList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size, String type) throws Exception {
        int start;
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 50;
        }
        if ((start = (page - 1) * size) < 0) {
            start = 0;
        }
        log.info((Object)("pageList : page= " + start + " , size=" + size));
        try {
            List ids = null;
            List totalids = new ArrayList();
            Boolean next = false;
            size = size + 1;
            if (type != null && !"".equals(type)) {
                ids = this.moduleService.getModuleIdsByType(type, Integer.valueOf(start), size);
                totalids = this.moduleService.getModuleIdsByType(type, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            } else {
                ids = this.moduleService.getModuleIds(Integer.valueOf(start), size);
                totalids = this.moduleService.getModuleIds(Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            }
            log.info((Object)("get countModuleIdsByType size is " + ids.size()));
            if (ids.size() != 0 && ids.size() > 0) {
                if (size.equals(ids.size())) {
                    next = true;
                    log.info((Object)("ss  " + ids.subList(0, size - 1)));
                    model.addAttribute("ids", ids.subList(0, size - 1));
                } else {
                    log.info((Object)("ss  " + ids.subList(0, ids.size())));
                    model.addAttribute("ids", ids.subList(0, ids.size()));
                }
                int totalCnt = totalids.size();
                model.addAttribute("total", (Object)totalCnt);
            } else {
                model.addAttribute("ids", (Object)ids);
            }
            model.addAttribute("code", (Object)0);
            model.addAttribute("size", (Object)(size - 1));
            model.addAttribute("page", (Object)page);
            model.addAttribute("next", (Object)next);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("get module list error,page is  " + start + " , size " + size));
            model.addAttribute("code", (Object)-100000);
        }
        return "/admin/module/json/moduleIdListJson";
    }
}

