/*
 * Decompiled with CFR 0.152.
 */
package com.atlascopco.admin.controller;

import com.atlascopco.admin.util.DynamicUtil;
import com.atlascopco.model.Manager;
import com.atlascopco.model.Role;
import com.atlascopco.service.ManagerService;
import com.atlascopco.service.RoleService;
import com.gemantic.common.util.PasswordUtils;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class ManagerController {
    private static final Log log = LogFactory.getLog(ManagerController.class);
    @Autowired
    private ManagerService managerService;
    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private RoleService roleService;

    @RequestMapping(value={"/a/u/manager"}, method={RequestMethod.POST})
    public String addManagerJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Manager manager) throws Exception {
        log.info((Object)("get manager is : " + manager));
        if (DataUtils.isNullOrEmpty((Object)manager.getName())) {
            model.addAttribute("code", (Object)-5007);
            return "common/fail";
        }
        if (DataUtils.isNullOrEmpty((Object)manager.getPwd())) {
            model.addAttribute("code", (Object)-5008);
            return "common/fail";
        }
        Long adminId = Long.valueOf(this.cookieUtil.getKeyIdentity(request, "userId"));
        String encodePass = PasswordUtils.encode((String)manager.getPwd());
        log.info((Object)("pwd encrypt is: " + encodePass));
        try {
            manager.setId(null);
            manager.setUpdateBy(adminId);
            manager.setCreateBy(adminId);
            manager.setPwd(encodePass);
            Long id = this.managerService.insert(manager);
            log.info((Object)("insert manager id is: " + id));
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)"add manager error ");
            model.addAttribute("code", (Object)-100000);
        }
        return "/common/json";
    }

    @RequestMapping(value={"/a/u/manager/{id}"}, method={RequestMethod.DELETE})
    public String deleteManagerJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        if (DataUtils.isNullOrEmpty((Object)id)) {
            log.info((Object)"get id is null\uff01");
            model.addAttribute("code", (Object)-1000);
            return "common/fail";
        }
        log.info((Object)("delete manager id is " + id));
        try {
            boolean result = this.managerService.delete(id);
            log.info((Object)("delete manager result: " + result));
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("delete manager error,id is  " + id));
            model.addAttribute("code", (Object)-6004);
        }
        return "/common/json";
    }

    @RequestMapping(value={"/a/u/manager/{id}"}, method={RequestMethod.PUT})
    public String updateManagerJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Manager manager, @PathVariable Long id) throws Exception {
        if (DataUtils.isNullOrEmpty((Object)manager)) {
            model.addAttribute("code", (Object)-1000);
            return "common/fail";
        }
        if (DataUtils.isNullOrEmpty((Object)manager.getName())) {
            model.addAttribute("code", (Object)-5007);
            return "common/fail";
        }
        if (DataUtils.isNullOrEmpty((Object)manager.getPwd())) {
            model.addAttribute("code", (Object)-5008);
            return "common/fail";
        }
        log.info((Object)("update manager is : " + manager));
        Long adminId = Long.valueOf(this.cookieUtil.getKeyIdentity(request, "userId"));
        try {
            Manager manager1 = this.managerService.getObjectById(id);
            log.info((Object)("get manager1 is : " + manager1));
            String oldPwd = PasswordUtils.encode((String)manager1.getPwd());
            log.info((Object)("get old pwdd is : " + oldPwd));
            manager.setCreateAt(manager1.getCreateAt());
            manager.setCreateBy(manager1.getCreateBy());
            manager.setUpdateBy(adminId);
            manager.setId(manager1.getId());
            String encodePass = PasswordUtils.encode((String)manager.getPwd());
            manager.setPwd(encodePass);
            log.info((Object)("get newPwd is : " + encodePass));
            boolean result = this.managerService.update(manager);
            log.info((Object)("update manager result is : " + result));
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("update manager error,id is  " + manager.getId()));
            model.addAttribute("code", (Object)-100000);
        }
        return "/common/json";
    }

    @RequestMapping(value={"/a/u/manager/search"}, method={RequestMethod.GET})
    public String getMultiManagerJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer roleId, String name, Integer page, Integer size) throws Exception {
        int start;
        log.info((Object)("param is =rid is: " + roleId + " name is: " + name + " page is: " + page + " size is:" + size));
        if (page == null || page <= 0) {
            page = 1;
        }
        if (size == null || size <= 0) {
            size = 10;
        }
        if ((start = (page - 1) * size) < 0) {
            start = 0;
        }
        log.info((Object)("page is:" + page + " size is :" + size + " start is :" + start));
        List managerIdList = null;
        List count = null;
        List managerList = null;
        Map param = null;
        List roleList = null;
        HashSet<Long> roleListSet = new HashSet<Long>();
        ArrayList managerDataList = new ArrayList();
        ArrayList<Long> ridList = new ArrayList<Long>();
        param = DynamicUtil.getManagerList((Integer)roleId, (String)name);
        try {
            managerIdList = this.managerService.getIdsByDynamicCondition(Manager.class, param, Integer.valueOf(start), size);
            log.info((Object)("get  managerIdList.size  is: " + managerIdList.size()));
            count = this.managerService.getIdsByDynamicCondition(Manager.class, param, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)("get count is :" + count));
            managerList = this.managerService.getObjectsByIds(managerIdList);
            log.info((Object)("get managerList.size is:" + managerIdList.size()));
            for (Manager m : managerList) {
                Long id = m.getRoleId();
                roleListSet.add(id);
            }
            ridList.addAll(roleListSet);
            log.info((Object)("get ridList is : " + ridList));
            roleList = this.roleService.getObjectsByIds(ridList);
            log.info((Object)("get roleList.size is : " + roleList.size()));
            for (Manager m : managerList) {
                for (Role r : roleList) {
                    if (!m.getRoleId().equals(r.getId())) continue;
                    HashMap<String, Object> managerData = new HashMap<String, Object>();
                    managerData.put("roleName", r.getName());
                    managerData.put("roleId", r.getId());
                    managerData.put("name", m.getName());
                    managerData.put("id", m.getId());
                    managerData.put("createAt", m.getCreateAt());
                    for (Manager manager : managerList) {
                        if (m.getCreateBy().equals(manager.getId())) {
                            managerData.put("createBy", manager.getName());
                        }
                        if (!m.getUpdateBy().equals(manager.getId())) continue;
                        managerData.put("updateBy", manager.getName());
                    }
                    managerData.put("updateAt", m.getUpdateAt());
                    managerDataList.add(managerData);
                }
            }
            model.addAttribute("code", (Object)0);
            model.addAttribute("page", (Object)page);
            model.addAttribute("size", (Object)size);
            model.addAttribute("total", (Object)count.size());
            model.addAttribute("managerList", managerDataList);
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("get manager error,id is  " + managerList.size()));
            model.addAttribute("code", (Object)-100000);
        }
        return "admin/manager/json/managerListJson";
    }

    @RequestMapping(value={"/a/u/manager/{id}"}, method={RequestMethod.GET})
    public String getManagerJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        log.info((Object)("get manager  id= " + id));
        try {
            Manager manager = this.managerService.getObjectById(id);
            log.info((Object)("get manager data is " + manager));
            model.addAttribute("code", (Object)0);
            model.addAttribute("manager", (Object)manager);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("get manager error,id is  " + id));
            model.addAttribute("code", (Object)-100000);
        }
        return "admin/manager/json/managerDetailJson";
    }

    @RequestMapping(value={"/a/u/pwd"}, method={RequestMethod.PUT})
    public String updateManagerPassword(HttpServletRequest request, HttpServletResponse response, ModelMap model, String oldPwd, String newPwd) throws Exception {
        log.info((Object)("get oldPwd is : " + oldPwd + " newPwd is : " + newPwd));
        Long uid = Long.valueOf(this.cookieUtil.getKeyIdentity(request, "userId"));
        if (oldPwd == null || newPwd == null || oldPwd.trim().equals("") || newPwd.trim().equals("")) {
            log.info((Object)" pwd  is null");
            model.addAttribute("code", (Object)-1004);
            return "/common/json";
        }
        if (oldPwd.length() > 200 || oldPwd.length() < 0 || newPwd.length() > 200 || newPwd.length() < 0) {
            log.info((Object)" pwd  is null");
            model.addAttribute("code", (Object)-5012);
            return "/common/json";
        }
        String oldPwdEncode = PasswordUtils.encode((String)oldPwd);
        Manager u = this.managerService.getObjectById(uid);
        log.info((Object)("get manager is : " + u));
        log.info((Object)("\u8f93\u5165\u7684\u65e7\u5bc6\u7801\uff1a" + oldPwdEncode));
        log.info((Object)("\u6570\u636e\u5e93\u7684\u65e7\u5bc6\u7801\uff1a" + u.getPwd()));
        if (u.getPwd().equals(oldPwdEncode)) {
            String newPwd1 = PasswordUtils.encode((String)newPwd);
            log.info((Object)("\u65b0\u5bc6\u7801\uff1a" + newPwd1));
            u.setPwd(newPwd1);
            u.setUpdateBy(uid);
            boolean result = this.managerService.update(u);
            log.info((Object)("update pwd result is : " + result));
            model.addAttribute("code", (Object)0);
        } else {
            model.addAttribute("code", (Object)-5006);
            model.addAttribute("result", (Object)"\u4f60\u8f93\u5165\u7684\u65e7\u5bc6\u7801\u6709\u8bef\uff01");
        }
        return "/common/json";
    }
}

