/*
 * Decompiled with CFR 0.152.
 */
package com.atlascopco.admin.controller;

import com.atlascopco.admin.util.DynamicUtil;
import com.atlascopco.model.Manager;
import com.atlascopco.model.Role;
import com.atlascopco.service.ManagerService;
import com.atlascopco.service.RoleService;
import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.common.util.json.GsonUtil;
import com.qding.common.util.pwd.PasswordUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class LoginController {
    private static final Log log = LogFactory.getLog(LoginController.class);
    @Autowired
    private ManagerService managerService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private CookieUtil cookieUtil;

    @RequestMapping(value={"/login/index"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size) throws Exception {
        log.info((Object)" welcome to manager index ");
        return "/index";
    }

    @RequestMapping(value={"/test"})
    public String test(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size) throws Exception {
        log.info((Object)" welcome to manager index ");
        return "/test";
    }

    @RequestMapping(value={"/nologin"})
    public String noLogin(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size) throws Exception {
        log.info((Object)" login wrong ");
        model.addAttribute("code", (Object)-5018);
        return "/data/json";
    }

    @RequestMapping(value={"/noPermissin"})
    public String noPermission(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size) throws Exception {
        log.info((Object)" login noPermission ");
        model.addAttribute("code", (Object)-5020);
        return "/data/json";
    }

    @RequestMapping(value={"/a/login"}, method={RequestMethod.POST})
    public String login(HttpServletRequest request, HttpServletResponse response, ModelMap model, String name, String pwd) {
        log.info((Object)" welcome to manager login ");
        try {
            Map param = DynamicUtil.getLogin((String)name);
            List managerIds = this.managerService.getIdsByDynamicCondition(Manager.class, param, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            log.info((Object)(name + " get managerIDs  " + managerIds));
            if (managerIds == null || managerIds.isEmpty() || managerIds.size() > 1) {
                log.info((Object)(name + " not get any user "));
                model.addAttribute("code", (Object)-5003);
            } else {
                log.info((Object)(name + "  get user " + managerIds.get(0)));
                Manager manager = this.managerService.getObjectById((Long)managerIds.get(0));
                log.info((Object)("get manager id is: " + manager.getId()));
                if (PasswordUtils.authenticatePassword((String)manager.getPwd(), (String)pwd) && manager.getStatus().equals("using")) {
                    log.info((Object)(managerIds.get(0) + " login "));
                    HashMap<String, String> maps = new HashMap<String, String>();
                    maps.put("managerName", manager.getName());
                    maps.put("userId", manager.getId() + "");
                    this.cookieUtil.setIdentity(request, response, maps, manager.getId());
                    Role role = this.roleService.getObjectById(manager.getRoleId());
                    if (role == null) {
                        log.error((Object)("not get any role  " + manager.getRoleId()));
                        model.addAttribute("code", (Object)-7001);
                        return "/common/json";
                    }
                    model.addAttribute("code", (Object)0);
                    model.addAttribute("manager", (Object)manager);
                    model.addAttribute("role", (Object)role);
                    log.info((Object)(managerIds.get(0) + " login over "));
                } else {
                    log.info((Object)(managerIds.get(0) + " has wrong pwd "));
                    model.addAttribute("code", (Object)-5004);
                    model.addAttribute("result", null);
                }
            }
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)("manager login error,name is  " + name));
            model.addAttribute("code", (Object)-5002);
            model.addAttribute("result", null);
        }
        return "/common/login";
    }

    @RequestMapping(value={"/a/logout"}, method={RequestMethod.POST})
    public String logout(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        log.info((Object)" welcome to manager logout ");
        try {
            this.cookieUtil.clearCookie(response);
            model.addAttribute("code", (Object)0);
            model.addAttribute("result", (Object)"/login/index");
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)"manager logout error  ");
            model.addAttribute("code", (Object)-5005);
            model.addAttribute("result", null);
        }
        return "/common/json";
    }

    @RequestMapping(value={"/a/u/manager"}, method={RequestMethod.GET})
    public String getUser(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        log.info((Object)" welcome to manager getmanager ");
        try {
            if (null != this.cookieUtil.getKeyIdentity(request, "userId")) {
                String userId = this.cookieUtil.getKeyIdentity(request, "userId");
                String userName = this.cookieUtil.getKeyIdentity(request, "managerName");
                String publicsHash = this.cookieUtil.getKeyIdentity(request, "managerPublicsHash");
                HashMap<String, String> maps = new HashMap<String, String>();
                maps.put("managerName", userName);
                maps.put("managerPublicsHash", publicsHash);
                maps.put("userId", userId);
                Manager manager = this.managerService.getObjectById(Long.valueOf(userId));
                model.addAttribute("code", (Object)0);
                model.addAttribute("result", (Object)GsonUtil.toJson((Object)manager));
            } else {
                model.addAttribute("code", (Object)-5001);
                model.addAttribute("result", null);
            }
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            log.error((Object)"manager logout error  ");
            model.addAttribute("code", (Object)-5001);
            model.addAttribute("result", null);
        }
        return "/common/json";
    }
}

