/*
 * Decompiled with CFR 0.152.
 */
package com.atlascopco.admin.controller;

import com.atlascopco.admin.util.DynamicUtil;
import com.atlascopco.model.Atlascopco;
import com.atlascopco.model.Manager;
import com.atlascopco.service.AtlascopcoService;
import com.atlascopco.service.ManagerService;
import com.google.gson.Gson;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class AtlascopcoController {
    private static final Log log = LogFactory.getLog(AtlascopcoController.class);
    @Autowired
    private AtlascopcoService atlascopcoService;
    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private ManagerService managerService;

    @RequestMapping(value={"/a/u/sort/{sortId}/products"}, method={RequestMethod.GET})
    public String getProductBySortId(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable(value="sortId") Integer sortId, Integer page, Integer size) {
        int start;
        log.info((Object)("sortId is:" + sortId + ";;;" + page + size));
        if (page == null) {
            page = 1;
        }
        if (sortId == null) {
            model.addAttribute("code", (Object)-10000);
            return "common/fail";
        }
        if (size == null) {
            size = 6;
        }
        if ((start = (page - 1) * size) < 0) {
            start = 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        List ids = null;
        List productList = null;
        List count = null;
        try {
            params.put("sort_id", sortId);
            params.put("@query", "id");
            params.put("@table", "atlascopco");
            params.put("@order", "update_at desc");
            ids = this.atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, Integer.valueOf(start), size);
            count = this.atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            productList = this.atlascopcoService.getObjectsByIds(ids);
            model.addAttribute("code", (Object)0);
            model.addAttribute("page", (Object)page);
            model.addAttribute("size", (Object)size);
            model.addAttribute("total", (Object)count.size());
            model.addAttribute("atlasList", (Object)productList);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)"get  productList  error  ");
            model.addAttribute("code", (Object)-100000);
        }
        return "atlascopco-service/atlascopco/json/atlascopcoListJson";
    }

    @RequestMapping(value={"/a/u/products/list"}, method={RequestMethod.PUT})
    public String getIdsNum(HttpServletRequest request, HttpServletResponse response, ModelMap model, @RequestBody List<Atlascopco> atlascopcoList) {
        log.info((Object)("get atlascopcoList is: " + atlascopcoList));
        Long adminId = Long.valueOf(this.cookieUtil.getKeyIdentity(request, "userId"));
        log.info((Object)("get adminId is : " + adminId));
        Gson gson = new Gson();
        try {
            for (int i = 0; i < atlascopcoList.size(); ++i) {
                String jc = gson.toJson((Object)atlascopcoList.get(i));
                log.info((Object)("atlascopcoList.get(" + i + ").getId() is : " + jc));
                Atlascopco at = (Atlascopco)gson.fromJson(jc, Atlascopco.class);
                log.info((Object)("atlas:" + at));
                if (at.getNum() == null) {
                    model.addAttribute("code", (Object)-1007);
                    return "common/fail";
                }
                Atlascopco atlascopcoInfo = this.atlascopcoService.getObjectById(at.getId());
                atlascopcoInfo.setUpdateBy(adminId);
                atlascopcoInfo.setNum(at.getNum());
                atlascopcoInfo.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
                this.atlascopcoService.update(atlascopcoInfo);
            }
            model.addAttribute("code", (Object)0);
            model.addAttribute("message", (Object)"\u4fee\u6539\u6210\u529f");
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)"update atlascopcoList error");
            model.addAttribute("code", (Object)-100000);
            return "common/fail";
        }
        return "common/success";
    }

    @RequestMapping(value={"/a/u/atlas"}, method={RequestMethod.GET})
    public String getProductList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer type, String title, String author, String creater, Integer status, Long startAt, Long endAt, Integer page, Integer size) throws Exception {
        int start;
        log.info((Object)("type is:" + type + ";;;" + page + size));
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        if ((start = (page - 1) * size) < 0) {
            start = 0;
        }
        if (type == null) {
            model.addAttribute("code", (Object)-1000);
            return "common/fail";
        }
        Map params = null;
        List ids = null;
        List count = null;
        List atlascopcoList = null;
        try {
            params = DynamicUtil.getList((Integer)type, (String)title, (String)author, (String)creater, (Integer)status, (Long)startAt, (Long)endAt);
            ids = this.atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, Integer.valueOf(start), size);
            count = this.atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            atlascopcoList = this.atlascopcoService.getObjectsByIds(ids);
            log.info((Object)("atlascopcoList is: " + atlascopcoList.size()));
            if (CollectionUtils.isEmpty((Collection)atlascopcoList)) {
                model.addAttribute("code", (Object)0);
                model.addAttribute("page", (Object)page);
                model.addAttribute("size", (Object)size);
                model.addAttribute("total", (Object)count.size());
                return "atlascopco-service/atlascopco/json/atlascopcoListJson";
            }
            model.addAttribute("code", (Object)0);
            model.addAttribute("page", (Object)page);
            model.addAttribute("size", (Object)size);
            model.addAttribute("total", (Object)count.size());
            model.addAttribute("atlasList", (Object)atlascopcoList);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)"get  atlascopcoList  error  ");
            model.addAttribute("code", (Object)-100000);
        }
        return "atlascopco-service/atlascopco/json/atlascopcoListJson";
    }

    @RequestMapping(value={"/a/u/atlas/{id}"}, method={RequestMethod.GET})
    public String getAtlascopcoJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        log.info((Object)("get data : id= " + id));
        try {
            Atlascopco atlascopco = this.atlascopcoService.getObjectById(id);
            log.info((Object)("get atlascopco data is: " + atlascopco.getId()));
            model.addAttribute("code", (Object)0);
            model.addAttribute("atlascopco", (Object)atlascopco);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("get atlascopco error,id is:  " + id));
            model.addAttribute("code", (Object)-100000);
            return "common/fail";
        }
        return "/atlascopco-service/atlascopco/json/atlascopcoDetailJson";
    }

    @RequestMapping(value={"/a/u/atlas"}, method={RequestMethod.POST})
    public String insertAtlascopco(HttpServletRequest request, HttpServletResponse response, ModelMap model, Atlascopco atlascopco) throws Exception {
        log.info((Object)("get atlascopco is: " + atlascopco));
        if (atlascopco.getType() == null || atlascopco.getType() == 0) {
            log.info((Object)"get atlas type is null");
            model.addAttribute("code", (Object)-1000);
            return "common/fail";
        }
        if (atlascopco.getTitle() == null) {
            log.info((Object)"get atlas title is null");
            model.addAttribute("code", (Object)-1001);
            return "common/fail";
        }
        if (atlascopco.getType() == 1 && null == atlascopco.getSortId()) {
            log.info((Object)"get atlas sortId is null");
            model.addAttribute("code", (Object)-1008);
            return "common/fail";
        }
        Long adminId = Long.valueOf(this.cookieUtil.getKeyIdentity(request, "userId"));
        log.info((Object)("get adminId is : " + adminId));
        try {
            atlascopco.setCreateBy(adminId);
            Manager manager = this.managerService.getObjectById(adminId);
            atlascopco.setCreater(manager.getName());
            atlascopco.setCreateAt(Long.valueOf(System.currentTimeMillis()));
            Long num = this.atlascopcoService.insert(atlascopco);
            if (atlascopco.getType() == 1) {
                atlascopco.setNum(num);
                atlascopco.setId(num);
                this.atlascopcoService.update(atlascopco);
            }
            log.info((Object)("insert atlascopco is: " + atlascopco.getTitle()));
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)"insert atlascopco error");
            model.addAttribute("code", (Object)-100000);
            return "common/fail";
        }
        return "common/success";
    }

    @RequestMapping(value={"/a/u/atlas/{id}"}, method={RequestMethod.PUT})
    public String updateAtlascopco(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id, @RequestBody Atlascopco atlascopco) throws Exception {
        response.setCharacterEncoding("utf-8");
        log.info((Object)("get atlascopco is: " + atlascopco));
        if (atlascopco.getTitle() == null) {
            log.info((Object)"get atlas title is null");
            model.addAttribute("code", (Object)-1001);
            return "common/fail";
        }
        Long adminId = Long.valueOf(this.cookieUtil.getKeyIdentity(request, "userId"));
        log.info((Object)("get adminId is : " + adminId));
        try {
            atlascopco.setId(id);
            atlascopco.setUpdateBy(adminId);
            atlascopco.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
            Atlascopco atlascopcoInfo = this.atlascopcoService.getObjectById(id);
            if (atlascopco.getType() != null) {
                atlascopcoInfo.setType(atlascopco.getType());
            }
            if (atlascopco.getTitle() != null) {
                atlascopcoInfo.setTitle(atlascopco.getTitle());
            }
            if (atlascopco.getAuthor() != null) {
                atlascopcoInfo.setAuthor(atlascopco.getAuthor());
            }
            if (atlascopco.getUrl() != null) {
                atlascopcoInfo.setUrl(atlascopco.getUrl());
            }
            if (atlascopco.getImg() != null) {
                atlascopcoInfo.setImg(atlascopco.getImg());
            }
            if (atlascopco.getIntroduce() != null) {
                atlascopcoInfo.setIntroduce(atlascopco.getIntroduce());
            }
            if (atlascopco.getContent() != null) {
                atlascopcoInfo.setContent(atlascopco.getContent());
            }
            if (atlascopco.getStatus() != null) {
                atlascopcoInfo.setStatus(atlascopco.getStatus());
            }
            if (atlascopco.getCreater() != null) {
                atlascopcoInfo.setCreater(atlascopco.getCreater());
            }
            if (atlascopco.getCreateAt() != null) {
                atlascopcoInfo.setCreateAt(atlascopco.getCreateAt());
            }
            if (atlascopco.getSortId() != null) {
                atlascopcoInfo.setSortId(atlascopco.getSortId());
            }
            if (atlascopco.getNum() != null) {
                atlascopcoInfo.setNum(atlascopco.getNum());
            }
            this.atlascopcoService.update(atlascopcoInfo);
            log.info((Object)("update id: " + atlascopcoInfo.getId()));
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)"update atlascopco error");
            model.addAttribute("code", (Object)-100000);
            return "common/fail";
        }
        return "common/success";
    }

    @RequestMapping(value={"/a/u/atlas/{id}"}, method={RequestMethod.DELETE})
    public String updateAtlascopco(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        log.info((Object)("delete  id  is: " + id));
        if (id == null) {
            model.addAttribute("code", (Object)-1001);
            return "common/fail";
        }
        Atlascopco atlascopco = this.atlascopcoService.getObjectById(id);
        try {
            if (atlascopco.getType() == 7) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("sort_id", id);
                params.put("@query", "id");
                params.put("@table", "atlascopco");
                List ids = this.atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                log.info((Object)("delete ids(type=7) :" + ids + ", ids.size : " + ids.size()));
                if (!ids.isEmpty()) {
                    model.addAttribute("code", (Object)-1009);
                    model.addAttribute("message", (Object)"\u8be5\u5206\u7c7b\u4e0b\u4ecd\u6709\u4ea7\u54c1");
                    return "common/sort";
                }
            }
            this.atlascopcoService.delete(id);
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("delete atlascopco error,id  is:" + id));
            model.addAttribute("code", (Object)-100000);
            return "common/fail";
        }
        return "common/success";
    }

    @RequestMapping(value={"/a/u/atlas/status/{id}"}, method={RequestMethod.PUT})
    public String updateAtlascopco(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id, Integer status) throws Exception {
        log.info((Object)("update status id is: " + id + ", status is:" + status));
        if (DataUtils.isNotNullOrEmpty((Object)status)) {
            log.info((Object)"get  status  is  null");
        }
        try {
            Atlascopco atlascopco = this.atlascopcoService.getObjectById(id);
            log.info((Object)("get  atlascopco  is: " + atlascopco));
            if (atlascopco.getTitle() == null) {
                model.addAttribute("code", (Object)-1001);
                return "common/fail";
            }
            if (status.equals(atlascopco.getStatus())) {
                model.addAttribute("code", (Object)-1005);
                return "common/fail";
            }
            atlascopco.setStatus(status);
            this.atlascopcoService.update(atlascopco);
            log.info((Object)("update id  is: " + id + "get atlascopco is: " + atlascopco));
            model.addAttribute("code", (Object)0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)("update atlascopco  status  error,id  is:" + id));
            model.addAttribute("code", (Object)-100000);
            return "common/fail";
        }
        return "common/success";
    }
}

