package com.atlascopco.admin.controller;

import com.atlascopco.admin.constant.ConstantItem;
import com.atlascopco.admin.util.DynamicUtil;
import com.atlascopco.model.Atlascopco;
import com.atlascopco.model.Manager;
import com.atlascopco.service.AtlascopcoService;
import com.atlascopco.service.ManagerService;
import com.google.gson.Gson;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 *
 * @author CK
 * @date 2017/11/22
 *
 *
 * @author ZQ
 * @date 2018/09/10
 *
 */

@Controller
public class AtlascopcoController {

    private static final Log log = LogFactory.getLog(AtlascopcoController.class);

    @Autowired
    private AtlascopcoService atlascopcoService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private ManagerService managerService;

    /**
     * 1、取分类下所有产品
     * @param: [request, response, model, sortId, page, size]
     * @return: java.lang.String
     * @auther: Zhang Qiang
     * @date: 2018/9/10 20:00
     * @info: 获取分类下所有产品 sortId = 分类id
     *
     */
    @RequestMapping(value = "/a/u/sort/{sortId}/products",method = RequestMethod.GET)
    public String getProductBySortId(HttpServletRequest request, HttpServletResponse response, ModelMap model,@PathVariable(value = "sortId") Integer sortId ,Integer page, Integer size){

        log.info("sortId is:" + sortId + ";;;" + page + size);

        if (page == null) {
            page = 1;
        }
        //判断sortId是否为空
        if (sortId == null) {
            model.addAttribute("code", -10000);
            return "common/fail";
        }

        if (size == null) {
            size = 6;
        }

        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        Map<String, Object> params = new HashMap<>();
        List<Long> ids = null;
        List<Atlascopco> productList = null;
        List<Long> count =null;

        try {

            params.put("sort_id",sortId);
            params.put("@query","id");
            params.put("@table", "atlascopco");
            params.put("@order", "update_at desc");
            ids = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, start, size);
            count = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, 0, Integer.MAX_VALUE);
            productList = atlascopcoService.getObjectsByIds(ids);


            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", count.size());
            model.addAttribute("atlasList", productList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get  productList  error  ");
            model.addAttribute("code", -100000);

        }

        return "atlascopco-service/atlascopco/json/atlascopcoListJson";
    }


    /**
     * 2、产品列表排序
     * @param: [request, response, model, atlascopcoList]
     * @return: java.lang.String
     * @auther: Zhang Qiang
     * @date: 2018/9/14 10:07
     * @info: 排序，批量修改产品num
     *
     */
    @RequestMapping(value = "/a/u/products/list",method = RequestMethod.PUT)
    public String getIdsNum(HttpServletRequest request, HttpServletResponse response, ModelMap model, @RequestBody List<Atlascopco> atlascopcoList){


        log.info("get atlascopcoList is: " + atlascopcoList);

        Long adminId = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));
        log.info("get adminId is : " + adminId);

        Gson gson = new Gson();
        try {

            for (int i=0;i<atlascopcoList.size();i++){

                String jc = gson.toJson(atlascopcoList.get(i));
                log.info("atlascopcoList.get(" + i + ").getId() is : " + jc);

                Atlascopco at = gson.fromJson(jc,Atlascopco.class);
                log.info("atlas:" + at);

                if (at.getNum() == null) {
                    model.addAttribute("code", -1007);
                    return "common/fail";
                }

                Atlascopco atlascopcoInfo = atlascopcoService.getObjectById(at.getId());
                atlascopcoInfo.setUpdateBy(adminId);
                atlascopcoInfo.setNum(at.getNum());
                atlascopcoInfo.setUpdateAt(System.currentTimeMillis());
                atlascopcoService.update(atlascopcoInfo);
            }

            model.addAttribute("code", 0);
            model.addAttribute("message", "修改成功");

        } catch (Throwable t) {

            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update atlascopcoList error");
            model.addAttribute("code", -100000);
            return "common/fail";

        }

        return "common/success";

    }


    /**
     * 1、查看列表
     *
     * @param request
     * @param response
     * @param model
     * @param type
     * @param title
     * @param author
     * @param creater
     * @param status
     * @param startAt
     * @param endAt
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/atlas", method = RequestMethod.GET)
    public String getProductList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer type, String title, String author, String creater, Integer status, Long startAt, Long endAt, Integer page, Integer size) throws Exception {

        log.info("type is:" + type + ";;;" + page + size);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        //判断type是否为空
        if (type == null) {
            model.addAttribute("code", -1000);
            return "common/fail";
        }

        Map<String, Object> params = null;
        List<Long> ids = null;
        List<Long> count = null;
        List<Atlascopco> atlascopcoList = null;

        try {

            params = DynamicUtil.getList(type, title, author, creater, status, startAt, endAt);
            ids = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, start, size);
            count = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, ConstantItem.ZERO, Integer.MAX_VALUE);

            //通过ids获取列表
            atlascopcoList = atlascopcoService.getObjectsByIds(ids);
            log.info("atlascopcoList is: " + atlascopcoList.size());

            //对获取的列表进行判空
            if (CollectionUtils.isEmpty(atlascopcoList)) {
                model.addAttribute("code", 0);
                model.addAttribute("page", page);
                model.addAttribute("size", size);
                model.addAttribute("total", count.size());
                return "atlascopco-service/atlascopco/json/atlascopcoListJson";
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", count.size());
            model.addAttribute("atlasList", atlascopcoList);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get  atlascopcoList  error  ");
            model.addAttribute("code", -100000);
        }

        return "atlascopco-service/atlascopco/json/atlascopcoListJson";
    }


    /**
     * 2、获取详情
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/atlas/{id}", method = RequestMethod.GET)
    public String getAtlascopcoJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        log.info("get data : id= " + id);

        try {
            Atlascopco atlascopco = atlascopcoService.getObjectById(id);
            log.info("get atlascopco data is: " + atlascopco.getId());

            model.addAttribute("code", 0);
            model.addAttribute("atlascopco", atlascopco);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get atlascopco error,id is:  " + id);
            model.addAttribute("code", -100000);

            return "common/fail";
        }

        return "/atlascopco-service/atlascopco/json/atlascopcoDetailJson";
    }


    /**
     * 3、新增信息
     *
     * @param request
     * @param response
     * @param model
     * @param atlascopco
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/atlas", method = RequestMethod.POST)
    public String insertAtlascopco(HttpServletRequest request, HttpServletResponse response, ModelMap model, Atlascopco atlascopco) throws Exception {

        log.info("get atlascopco is: " + atlascopco);

        if (atlascopco.getType() == null || atlascopco.getType()==0 ){
            log.info("get atlas type is null");
            model.addAttribute("code", -1000);
            return "common/fail";
        }

        if (atlascopco.getTitle() == null) {
            log.info("get atlas title is null");
            model.addAttribute("code", -1001);
            return "common/fail";
        }

        //产品需要添加分类
        if (atlascopco.getType() == 1){
            if (null == atlascopco.getSortId()) {
                log.info("get atlas sortId is null");
                model.addAttribute("code", -1008);
                return "common/fail";
            }
        }

        Long adminId = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));
        log.info("get adminId is : " + adminId);


        try {

            atlascopco.setCreateBy(adminId);
            Manager manager = managerService.getObjectById(adminId);
            atlascopco.setCreater(manager.getName());
            atlascopco.setCreateAt(System.currentTimeMillis());

            Long num = atlascopcoService.insert(atlascopco);

            // 产品添加排序
            if (atlascopco.getType()==1){
                atlascopco.setNum(num);
                atlascopco.setId(num);
                atlascopcoService.update(atlascopco);
            }

            log.info("insert atlascopco is: " + atlascopco.getTitle());
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("insert atlascopco error");
            model.addAttribute("code", -100000);
            return "common/fail";
        }
        return "common/success";
    }


    /**
     * 4、修改信息
     *
     * @param request
     * @param response
     * @param model
     * @param atlascopco
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/atlas/{id}", method = RequestMethod.PUT)
    public String updateAtlascopco(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id, @RequestBody Atlascopco atlascopco) throws Exception {
        response.setCharacterEncoding("utf-8");

        log.info("get atlascopco is: " + atlascopco);

        if (atlascopco.getTitle() == null) {
            log.info("get atlas title is null");
            model.addAttribute("code", -1001);
            return "common/fail";
        }

        Long adminId = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));
        log.info("get adminId is : " + adminId);

        try {

            atlascopco.setId(id);
            atlascopco.setUpdateBy(adminId);
            atlascopco.setUpdateAt(System.currentTimeMillis());

            //取原来的数据
            Atlascopco atlascopcoInfo = atlascopcoService.getObjectById(id);

            //判断现在修改的数据
            if (atlascopco.getType() != null){
                atlascopcoInfo.setType(atlascopco.getType());
            }
            if (atlascopco.getTitle() != null){
                atlascopcoInfo.setTitle(atlascopco.getTitle());
            }
            if (atlascopco.getAuthor() != null){
                atlascopcoInfo.setAuthor(atlascopco.getAuthor());
            }
            if (atlascopco.getUrl()!=null){
                atlascopcoInfo.setUrl(atlascopco.getUrl());
            }
            if (atlascopco.getImg()!=null){
                atlascopcoInfo.setImg(atlascopco.getImg());
            }
            if (atlascopco.getIntroduce()!=null){
                atlascopcoInfo.setIntroduce(atlascopco.getIntroduce());
            }
            if (atlascopco.getContent()!=null){
                atlascopcoInfo.setContent(atlascopco.getContent());
            }
            if (atlascopco.getStatus()!=null){
                atlascopcoInfo.setStatus(atlascopco.getStatus());
            }
            if (atlascopco.getCreater()!=null){
                atlascopcoInfo.setCreater(atlascopco.getCreater());
            }
            if (atlascopco.getCreateAt()!=null){
                atlascopcoInfo.setCreateAt(atlascopco.getCreateAt());
            }
            if (atlascopco.getSortId()!=null){
                atlascopcoInfo.setSortId(atlascopco.getSortId());
            }
            if (atlascopco.getNum()!=null){
                atlascopcoInfo.setNum(atlascopco.getNum());
            }

            //修改
            atlascopcoService.update(atlascopcoInfo);

            log.info("update id: " + atlascopcoInfo.getId());

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update atlascopco error");
            model.addAttribute("code", -100000);
            return "common/fail";
        }

        return "common/success";
    }


    /**
     * 5.删除信息
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     *
     */
    @RequestMapping(value = "/a/u/atlas/{id}", method = RequestMethod.DELETE)
    public String updateAtlascopco(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        log.info("delete  id  is: " + id);

        if (id == null) {
            model.addAttribute("code", -1001);
            return "common/fail";
        }

        Atlascopco atlascopco = atlascopcoService.getObjectById(id);

        try {

            //删除分类判断，不为空禁止删除
            if (atlascopco.getType() == ConstantItem.SERVEN){
                Map params = new HashMap();
                params.put("sort_id",id);
                params.put("@query","id");
                params.put("@table", "atlascopco");
                List<Long> ids = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, 0, Integer.MAX_VALUE);

                log.info("delete ids(type=7) :"+ ids + ", ids.size : " + ids.size());

                // ids里有元素
                if (!ids.isEmpty() ){
                    model.addAttribute("code", -1009);
                    model.addAttribute("message", "该分类下仍有产品");
                    return "common/sort";
                }
            }

            atlascopcoService.delete(id);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete atlascopco error,id  is:" + id);
            model.addAttribute("code", -100000);
            return "common/fail";
        }
        return "common/success";
    }

    /**
     *  6、修改状态
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @param status
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/atlas/status/{id}", method = RequestMethod.PUT)
    public String updateAtlascopco(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id, Integer status) throws Exception {

        log.info("update status id is: " + id + ", status is:" + status);

        if (DataUtils.isNotNullOrEmpty(status)) {
            log.info("get  status  is  null");
        }

        try {
            Atlascopco atlascopco = atlascopcoService.getObjectById(id);
            log.info("get  atlascopco  is: "+ atlascopco);

            if (atlascopco.getTitle() == null) {
                model.addAttribute("code",-1001);
                return "common/fail";
            }
            if (status.equals(atlascopco.getStatus())) {
                model.addAttribute("code",-1005);
                return "common/fail";
            }

            atlascopco.setStatus(status);
            atlascopcoService.update(atlascopco);
            log.info("update id  is: " + id +"get atlascopco is: "+ atlascopco);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update atlascopco  status  error,id  is:" + id);
            model.addAttribute("code", -100000);
            return "common/fail";
        }
        return "common/success";
    }
}