package com.atlascopco.admin.util;

import com.ptteng.common.dao.util.SQLUtil;
import com.qding.common.util.DataUtils;
import org.apache.log4j.Logger;

import java.util.HashMap;
import java.util.Map;


/**
 * @author CK
 */
public class DynamicUtil {
    private static final Logger log = Logger.getLogger(DynamicUtil.class);
    private static Map<String, Object> applyManageList;


    /**
     *  1、获取列表
     * @param type
     * @param title
     * @param author
     * @param creater
     * @param status
     * @param startAt
     * @param endAt
     * @return
     */
    public static Map<String, Object> getList(Integer type, String title, String author, String creater,
                                              Integer status, Long startAt, Long endAt) {
        Map<String, Object> params = new HashMap<String, Object>();

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", type);
        }
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put("title & like", "'%" + title + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(author)) {
            params.put("author & like","'%" + author + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(creater)) {
            params.put("creater & like","'%" + creater + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(startAt)){
            params.put("update_at & >",startAt);
        }
        if (DataUtils.isNotNullOrEmpty(endAt)){
            params.put("update_at & <",endAt);
        }

        params.put("@query", "id");
        params.put("@table", "atlascopco");
        params.put("@order", "status desc, update_at desc");

        log.info(SQLUtil.convert2Sql(params, 0, Integer.MAX_VALUE));

        return params;
    }

    /**
     * manager列表搜索
     *
     * @param roleId
     * @param name
     * @return
     */
    public static Map<String, Object> getManagerList(Integer roleId, String name) {
        Map<String, Object> params = new HashMap<String, Object>();

        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("m.name & like", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(roleId)) {
            params.put("m.role_id", roleId);
        }

        params.put("@query", "m.id");
        params.put("@table", "manager m,role r");
        params.put("m.role_id", "r.id");
        params.put("@order", "m.create_at desc");

        log.info(SQLUtil.convert2Sql(params, 0, Integer.MAX_VALUE));
        return params;
    }


    /**
     * 登录
     *
     * @param name
     * @return
     */
    public static Map<String, Object> getLogin(String name) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("@query", "id");
        params.put("@table", "manager");
        params.put("name & like", "'%" + name + "%'");

        log.info(SQLUtil.convert2Sql(params, 0, Integer.MAX_VALUE));
        return params;
    }

}
