package com.atlascopco.admin.controller;

import com.atlascopco.admin.constant.ConstantItem;
import com.atlascopco.admin.util.DynamicUtil;
import com.atlascopco.model.Atlascopco;
import com.atlascopco.model.Manager;
import com.atlascopco.service.AtlascopcoService;
import com.atlascopco.service.ManagerService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;

import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;


/**
 *
 * @author CK
 * @date 2017/11/22
 */

@Controller
public class AtlascopcoController {

    private static final Log log = LogFactory.getLog(AtlascopcoController.class);

    @Autowired
    private AtlascopcoService atlascopcoService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private ManagerService managerService;


    /**
     * 1、查看列表
     *
     * @param request
     * @param response
     * @param model
     * @param type
     * @param title
     * @param author
     * @param creater
     * @param status
     * @param startAt
     * @param endAt
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/atlas", method = RequestMethod.GET)
    public String getProductList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer type, String title, String author, String creater, Integer status, Long startAt, Long endAt, Integer page, Integer size) throws Exception {

        log.info("type is:" + type + ";;;" + page + size);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        //判断type是否为空
        if (type == null) {
            model.addAttribute("code", -1000);
            return "common/fail";
        }

        Map<String, Object> params = null;
        List<Long> ids = null;
        List<Long> count = null;
        List<Atlascopco> atlascopcoList = null;

        try {
            //当type为1时，表示搜索的结果为产品列表
            if (type == ConstantItem.ONE) {
                params = DynamicUtil.getList(type, title, author, creater, status, startAt, endAt);
                ids = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, start, size);
                count = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, start, Integer.MAX_VALUE);
            }
            //当type为2时，搜索为招聘信息列表，获取所有
            if (type == ConstantItem.TWO) {
                params = DynamicUtil.getList(type, title, author, creater, status, startAt, endAt);
                ids = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, start, size);
                count = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, start, Integer.MAX_VALUE);
            }
            //当type为3时，搜索为售后服务列表
            if (type == ConstantItem.THREE) {
                params = DynamicUtil.getList(type, title, author, creater, status, startAt, endAt);
                ids = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, start, size);
                count = atlascopcoService.getIdsByDynamicCondition(Atlascopco.class, params, start, Integer.MAX_VALUE);
            }

            //通过ids获取列表
            atlascopcoList = atlascopcoService.getObjectsByIds(ids);
            log.info("atlascopcoList is: " + atlascopcoList.size());

            //对获取的列表进行判空
            if (atlascopcoList == null) {
                model.addAttribute("code", 0);
                model.addAttribute("page", page);
                model.addAttribute("size", size);
                model.addAttribute("total", count.size());
                return "atlascopco-service/atlascopco/json/atlascopcoListJson";
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", count.size());
            model.addAttribute("atlasList", atlascopcoList);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get  atlascopcoList  error  ");
            model.addAttribute("code", -100000);
        }

        return "atlascopco-service/atlascopco/json/atlascopcoListJson";
    }


    /**
     * 2、获取详情
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/atlas/{id}", method = RequestMethod.GET)
    public String getAtlascopcoJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        log.info("get data : id= " + id);

        try {
            Atlascopco atlascopco = atlascopcoService.getObjectById(id);
            log.info("get atlascopco data is: " + atlascopco.getId());

            model.addAttribute("code", 0);
            model.addAttribute("atlascopco", atlascopco);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get atlascopco error,id is:  " + id);
            model.addAttribute("code", -100000);

            return "common/fail";
        }

        return "/atlascopco-service/atlascopco/json/atlascopcoDetailJson";
    }


    /**
     * 3、新增信息
     *
     * @param request
     * @param response
     * @param model
     * @param atlascopco
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/atlas", method = RequestMethod.POST)
    public String insertAtlascopco(HttpServletRequest request, HttpServletResponse response, ModelMap model, Atlascopco atlascopco) throws Exception {


        log.info("get atlascopco is: " + atlascopco);

        if (atlascopco.getTitle() == null) {
            log.info("get atlas title is null");
            model.addAttribute("cdoe", -1001);
            return "common/fail";
        }
        if (null == atlascopco.getContent()) {
            log.info("get atlas content is null");
            model.addAttribute("cdoe", -1002);
            return "common/fail";
        }

        Long adminId = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));
        log.info("get adminId is : " + adminId);

        try {
            atlascopco.setCreateBy(adminId);
            Manager manager = managerService.getObjectById(adminId);
            atlascopco.setCreater(manager.getName());


            atlascopcoService.insert(atlascopco);
            log.info("insert atlascopco  is: " + atlascopco.getTitle());
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("insert atlascopco error");
            model.addAttribute("code", -100000);
            return "common/fail";
        }
        return "common/success";
    }


    /**
     * 4、修改信息
     *
     * @param request
     * @param response
     * @param model
     * @param atlascopco
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/atlas/{id}", method = RequestMethod.PUT)
    public String updateAtlascopco(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id, @RequestBody Atlascopco atlascopco) throws Exception {

        log.info("get atlascopco is: " + atlascopco);

        if (atlascopco.getTitle() == null) {
            log.info("get atlas title is null");
            model.addAttribute("cdoe", -1001);
            return "common/fail";
        }
        if (null == atlascopco.getContent()) {
            log.info("get atlas content is null");
            model.addAttribute("cdoe", -1002);
            return "common/fail";
        }

        Long adminId = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));
        log.info("get adminId is : " + adminId);

        try {
            atlascopco.setId(id);
            atlascopco.setUpdateBy(adminId);

            atlascopcoService.update(atlascopco);
            log.info("update id: " + atlascopco.getId());

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update atlascopco error");
            model.addAttribute("code", -100000);
            return "common/fail";
        }

        return "common/success";
    }


    /**
     * 5.删除信息
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/atlas/{id}", method = RequestMethod.DELETE)
    public String updateAtlascopco(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        log.info("delete  id  is: " + id);

        if (id == null) {
            model.addAttribute("cdoe", -1001);
            return "common/fail";
        }

        try {
            atlascopcoService.delete(id);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete atlascopco error,id  is:" + id);
            model.addAttribute("code", -100000);
            return "common/fail";
        }
        return "common/success";
    }

    /**
     *  6、修改状态
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @param status
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/atlas/status/{id}", method = RequestMethod.PUT)
    public String updateAtlascopco(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id, Integer status) throws Exception {

        log.info("update  status id is: " + id + ", status is:" + status);

        if (DataUtils.isNotNullOrEmpty(status)) {
            log.info("get  status  is  null");
        }

        try {
            Atlascopco atlascopco = atlascopcoService.getObjectById(id);
            log.info("get  atlascopco  is: "+ atlascopco);

            if (atlascopco.getTitle() == null) {
                model.addAttribute("code",-1001);
                return "common/fail";
            }
            if (status.equals(atlascopco.getStatus())) {
                model.addAttribute("code",-1005);
                return "common/fail";
            }

            atlascopco.setStatus(status);
            atlascopcoService.update(atlascopco);
            log.info("update id  is: " + id +"get atlascopco is: "+ atlascopco);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update atlascopco  status  error,id  is:" + id);
            model.addAttribute("code", -100000);
            return "common/fail";
        }
        return "common/success";
    }
}