/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.configurable;

import java.util.List;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.configurable.ExtractRule;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.utils.Experimental;

@Experimental
public class ConfigurablePageProcessor
implements PageProcessor {
    private Site site;
    private List<ExtractRule> extractRules;

    public ConfigurablePageProcessor(Site site, List<ExtractRule> extractRules) {
        this.site = site;
        this.extractRules = extractRules;
    }

    public void process(Page page) {
        for (ExtractRule extractRule : this.extractRules) {
            if (extractRule.isMulti()) {
                List results = page.getHtml().selectDocumentForList(extractRule.getSelector());
                if (extractRule.isNotNull() && results.size() == 0) {
                    page.setSkip(true);
                    continue;
                }
                page.getResultItems().put(extractRule.getFieldName(), (Object)results);
                continue;
            }
            String result = page.getHtml().selectDocument(extractRule.getSelector());
            if (extractRule.isNotNull() && result == null) {
                page.setSkip(true);
                continue;
            }
            page.getResultItems().put(extractRule.getFieldName(), (Object)result);
        }
    }

    public Site getSite() {
        return this.site;
    }
}

