/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.example;

import java.util.List;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.configurable.Inject;
import us.codecraft.webmagic.processor.PageProcessor;

public class ConfigurableBlogPageProcessor
implements PageProcessor {
    private Site site = Site.me().setDomain("my.oschina.net");
    @Inject(value="linkRegex")
    private String linkRegex;
    @Inject(value="titleXpath")
    private String titleXpath;
    @Inject(value="contentXpath")
    private String contentXpath;
    @Inject(value="tagsXpath")
    private String tagsXpath;

    public void process(Page page) {
        List links = page.getHtml().links().regex(this.linkRegex).all();
        page.addTargetRequests(links);
        page.putField("title", (Object)page.getHtml().xpath(this.titleXpath).toString());
        if (page.getResultItems().get("title") == null) {
            page.setSkip(true);
        }
        page.putField("content", (Object)page.getHtml().smartContent().toString());
        page.putField("tags", (Object)page.getHtml().xpath(this.tagsXpath).all());
    }

    public Site getSite() {
        return this.site;
    }

    public static void main(String[] args) {
        Spider.create((PageProcessor)new ConfigurableBlogPageProcessor()).addUrl(new String[]{"http://my.oschina.net/flashsword/blog"}).thread(2).run();
    }
}

