/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.support.WebApplicationObjectSupport;

public abstract class WebContentGenerator
extends WebApplicationObjectSupport {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    public static final String HEADER_PRAGMA = "Pragma";
    public static final String HEADER_EXPIRES = "Expires";
    public static final String HEADER_CACHE_CONTROL = "Cache-Control";
    private Set supportedMethods = new HashSet();
    private boolean requireSession = false;
    private boolean useExpiresHeader = true;
    private boolean useCacheControlHeader = true;
    private int cacheSeconds = -1;

    public WebContentGenerator() {
        this.supportedMethods.add(METHOD_GET);
        this.supportedMethods.add(METHOD_POST);
    }

    public final void setSupportedMethods(String[] supportedMethodsArray) {
        if (supportedMethodsArray == null || supportedMethodsArray.length == 0) {
            throw new IllegalArgumentException("supportedMethods must not be empty");
        }
        this.supportedMethods.clear();
        for (int i = 0; i < supportedMethodsArray.length; ++i) {
            this.supportedMethods.add(supportedMethodsArray[i]);
        }
    }

    public final void setRequireSession(boolean requireSession) {
        this.requireSession = requireSession;
    }

    public final void setUseExpiresHeader(boolean useExpiresHeader) {
        this.useExpiresHeader = useExpiresHeader;
    }

    public final void setUseCacheControlHeader(boolean useCacheControlHeader) {
        this.useCacheControlHeader = useCacheControlHeader;
    }

    public final void setCacheSeconds(int seconds) {
        this.cacheSeconds = seconds;
    }

    protected final void checkAndPrepare(HttpServletRequest request, HttpServletResponse response, boolean lastModified) throws ServletException {
        this.checkAndPrepare(request, response, this.cacheSeconds, lastModified);
    }

    protected final void checkAndPrepare(HttpServletRequest request, HttpServletResponse response, int cacheSeconds, boolean lastModified) throws ServletException {
        String method = request.getMethod();
        if (!this.supportedMethods.contains(method)) {
            this.logger.info((Object)("Disallowed '" + method + "' request"));
            throw new ServletException("This resource does not support request method '" + method + "'");
        }
        if (this.requireSession && request.getSession(false) == null) {
            throw new ServletException("This resource requires a pre-existing HttpSession: none was found");
        }
        this.applyCacheSeconds(response, cacheSeconds, lastModified);
    }

    protected final void preventCaching(HttpServletResponse response) {
        response.setHeader(HEADER_PRAGMA, "No-cache");
        if (this.useExpiresHeader) {
            response.setDateHeader(HEADER_EXPIRES, 1L);
        }
        if (this.useCacheControlHeader) {
            response.setHeader(HEADER_CACHE_CONTROL, "no-cache");
        }
    }

    protected final void cacheForSeconds(HttpServletResponse response, int seconds) {
        this.cacheForSeconds(response, seconds, false);
    }

    protected final void cacheForSeconds(HttpServletResponse response, int seconds, boolean mustRevalidate) {
        if (this.useExpiresHeader) {
            response.setDateHeader(HEADER_EXPIRES, System.currentTimeMillis() + (long)seconds * 1000L);
        }
        if (this.useCacheControlHeader) {
            String headerValue = "max-age=" + seconds;
            if (mustRevalidate) {
                headerValue = headerValue + ", must-revalidate";
            }
            response.setHeader(HEADER_CACHE_CONTROL, headerValue);
        }
    }

    protected final void applyCacheSeconds(HttpServletResponse response, int seconds) {
        this.applyCacheSeconds(response, seconds, false);
    }

    protected final void applyCacheSeconds(HttpServletResponse response, int seconds, boolean mustRevalidate) {
        if (seconds > 0) {
            this.cacheForSeconds(response, seconds, mustRevalidate);
        } else if (seconds == 0) {
            this.preventCaching(response);
        }
    }
}

