/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.host.rmi;

import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import scallop.sca.host.rmi.RMIHost;
import scallop.sca.host.rmi.RMIHostException;
import scallop.sca.host.rmi.RMIHostRuntimeException;

public class DefaultRMIHost
implements RMIHost {
    private Map<String, Registry> rmiRegistries = new ConcurrentHashMap<String, Registry>();

    @Override
    public void registerService(String serviceName, int port, Remote serviceObject) throws RMIHostException, RMIHostRuntimeException {
        try {
            Registry registry = this.rmiRegistries.get(Integer.toString(port));
            if (registry == null) {
                try {
                    registry = LocateRegistry.getRegistry(port);
                    registry.list();
                }
                catch (RemoteException e) {
                    registry = LocateRegistry.createRegistry(port);
                }
                this.rmiRegistries.put(Integer.toString(port), registry);
            }
            registry.bind(serviceName, serviceObject);
        }
        catch (AlreadyBoundException e) {
            throw new RMIHostException(e);
        }
        catch (RemoteException e) {
            RMIHostRuntimeException rmiExec = new RMIHostRuntimeException(e.getMessage());
            rmiExec.setStackTrace(e.getStackTrace());
            throw rmiExec;
        }
    }

    @Override
    public void registerService(String serviceName, Remote serviceObject) throws RMIHostException, RMIHostRuntimeException {
        this.registerService(serviceName, 1099, serviceObject);
    }

    @Override
    public void unregisterService(String serviceName, int port) throws RMIHostException, RMIHostRuntimeException {
        try {
            Registry registry = this.rmiRegistries.get(Integer.toString(port));
            if (registry == null) {
                registry = LocateRegistry.getRegistry(port);
                this.rmiRegistries.put(Integer.toString(port), registry);
            }
            registry.unbind(serviceName);
        }
        catch (RemoteException e) {
            RMIHostRuntimeException rmiExec = new RMIHostRuntimeException(e.getMessage());
            rmiExec.setStackTrace(e.getStackTrace());
            throw rmiExec;
        }
        catch (NotBoundException e) {
            throw new RMIHostException(e.getMessage());
        }
    }

    @Override
    public void unregisterService(String serviceName) throws RMIHostException, RMIHostRuntimeException {
        this.unregisterService(serviceName, 1099);
    }

    @Override
    public Remote findService(String host, String port, String svcName) throws RMIHostException, RMIHostRuntimeException {
        Remote remoteService = null;
        host = host == null || host.length() <= 0 ? "localhost" : host;
        int portNumber = port == null || port.length() <= 0 ? 1099 : Integer.decode(port);
        try {
            Registry registry = LocateRegistry.getRegistry(host, portNumber);
            if (registry != null) {
                remoteService = registry.lookup(svcName);
            }
        }
        catch (RemoteException e) {
            RMIHostRuntimeException rmiExec = new RMIHostRuntimeException(e.getMessage());
            rmiExec.setStackTrace(e.getStackTrace());
            throw rmiExec;
        }
        catch (NotBoundException e) {
            throw new RMIHostException(e.getMessage());
        }
        return remoteService;
    }
}

