/*
 * Decompiled with CFR 0.152.
 */
package scallop.core.loadbalance;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import scallop.core.loadbalance.LoadBalancer;
import scallop.core.loadbalance.ResourceLoader;

public class RoundRobinLoadBalancer<T>
implements LoadBalancer<T> {
    private final AtomicInteger nextIndex = new AtomicInteger();
    private List<T> resourceList = new ArrayList<T>();

    @Override
    public List<T> getResources() {
        return this.resourceList;
    }

    public RoundRobinLoadBalancer(List<T> resourceList) {
        this.resourceList = new ArrayList<T>(resourceList);
    }

    @Override
    public ResourceLoader<T> get() {
        if (this.resourceList.size() == 0) {
            return null;
        }
        int index = Math.abs(this.nextIndex.getAndIncrement() % this.resourceList.size());
        T resource = this.resourceList.get(index);
        return new ResourceLoader<T>(index, resource);
    }

    @Override
    public ResourceLoader<T> get(ResourceLoader<T> proxy) {
        int index = (proxy.getId() + 1) % this.resourceList.size();
        T resource = this.resourceList.get(index);
        return new ResourceLoader<T>(index, resource);
    }

    @Override
    public int getResourceSize() {
        return this.resourceList.size();
    }
}

