/*
 * Decompiled with CFR 0.152.
 */
package scallop.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.Client;
import org.restlet.data.Protocol;
import org.restlet.data.Response;
import scallop.api.ScallopRemoteException;
import scallop.core.Observer;
import scallop.core.Resource;
import scallop.core.ResourceParser;
import scallop.core.Subject;
import scallop.core.thread.factory.DaemonThreadFactory;

public class ScallopClient
implements Subject {
    private static final Logger logger = Logger.getLogger(ScallopClient.class.getName());
    private static final String SUFFIX = "}";
    private static final String PREFIX = "${";
    private static final String SCALLOP_PROPERTIES = "scallop.properties";
    private static final String SPLIT = "|||";
    private static final String COMMA = ",";
    private static final String SLASH = "/";
    private static final String SCALLOP_REGISTRY_CENTER = "scallop.registry.center";
    private static final String SCALLOP_PERFORMACE_RMI_PROCESSTIME_THRESHOLD = "scallop.performace.rmi.processTimeThreshold";
    private static final String SCALLOP_PERFORMACE_RMI_SHOW_PARAMETERS = "scallop.performace.rmi.showParameters";
    private static final String SCALLOP_PERFORMACE_RMI_EXECUTE_TIMES_PRINT_INTERVAL = "scallop.performace.rmi.executeTimesPrintInterval";
    private static final String SCALLOP_OBSERVER_DELAY = "scallop.observer.delay";
    private static final String SCALLOP_OBSERVER_INTERVAL = "scallop.observer.interval";
    protected Map<String, Resource> registryCenterMap = new ConcurrentHashMap<String, Resource>();
    private static Properties properties = new Properties();
    private static ScallopClient instance;
    protected final ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory(""));
    private List<Observer> observers = new ArrayList<Observer>();

    private ScallopClient() {
        InputStream inputStream = ScallopClient.getDefaultClassLoader().getResourceAsStream(SCALLOP_PROPERTIES);
        try {
            if (inputStream != null) {
                properties.load(inputStream);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static String getProperty(String name) {
        return properties.getProperty(name, null);
    }

    public long getRmiProcessTimeThreshold() {
        String str = ScallopClient.getProperty(SCALLOP_PERFORMACE_RMI_PROCESSTIME_THRESHOLD);
        if (str == null) {
            return 50L;
        }
        return Long.parseLong(str);
    }

    public boolean getRmiShowParameters() {
        String str = ScallopClient.getProperty(SCALLOP_PERFORMACE_RMI_SHOW_PARAMETERS);
        return "true".equalsIgnoreCase(str);
    }

    public long getRmiExecuteTimesPrintInterval() {
        String str = ScallopClient.getProperty(SCALLOP_PERFORMACE_RMI_EXECUTE_TIMES_PRINT_INTERVAL);
        if (str == null) {
            return 3600000L;
        }
        return Long.parseLong(str);
    }

    public String getRealRegistryCenter(String registryCenter) {
        if (registryCenter == null) {
            registryCenter = ScallopClient.getProperty(SCALLOP_REGISTRY_CENTER);
        } else if (registryCenter.startsWith(PREFIX) && registryCenter.endsWith(SUFFIX)) {
            registryCenter = ScallopClient.getProperty(registryCenter.replace(PREFIX, "").replace(SUFFIX, ""));
        }
        return registryCenter;
    }

    public static synchronized ScallopClient getInstance() {
        if (instance == null) {
            instance = new ScallopClient();
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    instance.registryCenterMap.clear();
                    instance.notifyObservers();
                }
            };
            Integer delayTime = 5;
            String delay = ScallopClient.getProperty(SCALLOP_OBSERVER_DELAY);
            if (delay != null && !"".equals(delay)) {
                delayTime = Integer.valueOf(delay);
            }
            Integer intervalTime = 5;
            String interval = ScallopClient.getProperty(SCALLOP_OBSERVER_INTERVAL);
            if (interval != null && !"".equals(interval)) {
                intervalTime = Integer.valueOf(interval);
            }
            logger.info("delayTime " + delayTime + " intervalTime " + intervalTime);
            ScallopClient.instance.exec.scheduleAtFixedRate(task, delayTime.intValue(), intervalTime.intValue(), TimeUnit.MINUTES);
        }
        return instance;
    }

    public Resource getResource(String registryCenter, String registryName, ResourceParser parser) throws ScallopRemoteException {
        String[] strings;
        Resource resource;
        if (registryName == null || registryCenter == null) {
            new NullPointerException("registryCenter or registryName is null. registryCenter:" + registryCenter + "registryName:" + registryName);
        }
        if ((resource = this.registryCenterMap.get(new StringBuffer(registryCenter).append(SPLIT).append(registryName).toString())) != null) {
            return resource;
        }
        logger.log(Level.INFO, "get resource form registry center. registryCenter:" + registryCenter + " registryName:" + registryName);
        Client client = new Client(Protocol.HTTP);
        String[] stringArray = strings = registryCenter.split(COMMA);
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String rc = stringArray[n2];
            String url = new StringBuffer(rc).append(SLASH).append("resources").append(SLASH).append(registryName).toString();
            Response response = client.get(url);
            if (response.getStatus().isSuccess() && response.isEntityAvailable()) {
                try {
                    JSONObject jsonObject = new JSONObject(response.getEntity().getText());
                    logger.log(Level.INFO, "resource:" + jsonObject.toString());
                    resource = parser.parse(jsonObject);
                    this.registryCenterMap.put(new StringBuffer(registryCenter).append(SPLIT).append(registryName).toString(), resource);
                    return resource;
                }
                catch (IOException e) {
                    throw new ScallopRemoteException(e.getMessage(), (Throwable)e);
                }
                catch (JSONException e) {
                    throw new ScallopRemoteException(e.getMessage(), (Throwable)e);
                }
            }
            ++n2;
        }
        throw new ScallopRemoteException("get resources error. registryCenter:" + registryCenter + " registryName:" + registryName);
    }

    @Override
    public void notifyObservers() {
        for (Observer o : this.observers) {
            try {
                o.update();
            }
            catch (ScallopRemoteException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Observer registerObserver(Observer o) {
        this.observers.add(o);
        return o;
    }

    @Override
    public void removeObserver(Observer o) {
        int i = this.observers.indexOf(o);
        if (i > -1) {
            this.observers.remove(i);
        }
    }

    private static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = ScallopClient.class.getClassLoader();
        }
        return cl;
    }

    /* synthetic */ ScallopClient(ScallopClient scallopClient) {
        this();
    }

    static class SingletonHolder {
        static ScallopClient instance = new ScallopClient(null);

        SingletonHolder() {
        }
    }
}

