/*
 * Decompiled with CFR 0.152.
 */
package scallop.center.rest;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.json.JSONException;
import org.json.JSONObject;
import scallop.api.ScallopServerDaoException;
import scallop.center.dao.Resource;
import scallop.center.dao.ibatis.ResourceDaoIbatis;

@Path(value="resources")
public class ResourcesService {
    private static final String RESOURCE = "resource";
    private static final String NAME = "name";
    private static final String STRATEGY = "strategy";

    @GET
    @Path(value="{name}")
    @Produces(value={"text/html"})
    public String getResource(@PathParam(value="name") String name) throws ScallopServerDaoException, JSONException {
        ResourceDaoIbatis dao = new ResourceDaoIbatis();
        Resource resource = dao.getResourceByName(name);
        JSONObject jsonObject = new JSONObject();
        jsonObject.accumulate(NAME, (Object)name);
        jsonObject.accumulate(RESOURCE, (Object)resource.getResource());
        jsonObject.accumulate(STRATEGY, (Object)resource.getStrategy());
        return jsonObject.toString();
    }

    @GET
    @Produces(value={"text/html"})
    public String getHtml() {
        return "<html><head></head><body>\nwelcome to  resource (as html text).\n</body></html>";
    }
}

