/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.rmi.impl;

import java.net.URI;
import java.net.URISyntaxException;
import scallop.sca.binding.rmi.RMIBinding;

public class RMIBindingImpl
implements RMIBinding {
    private String registryCenter;
    private String registryName;
    private String name;
    private String uri;
    private String port;
    private String host;
    private String serviceName;

    @Override
    public String getRegistryCenter() {
        return this.registryCenter;
    }

    @Override
    public void setRegistryCenter(String registryCenter) {
        this.registryCenter = registryCenter;
    }

    @Override
    public String getRegistryName() {
        return this.registryName;
    }

    @Override
    public void setRegistryName(String registryName) {
        this.registryName = registryName;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    @Override
    public void setPort(String port) {
        this.port = port;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public void setServiceName(String rmiServiceName) {
        this.serviceName = rmiServiceName;
    }

    public String getName() {
        return this.name;
    }

    public String getURI() {
        this.compose();
        return this.uri;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setURI(String uri) {
        this.uri = uri;
        this.parse(uri);
    }

    public boolean isUnresolved() {
        return false;
    }

    public void setUnresolved(boolean unresolved) {
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void parse(String uriStr) {
        if (uriStr == null) {
            return;
        }
        URI uri = URI.create(uriStr);
        if (this.host == null) {
            this.host = uri.getHost();
        }
        if (this.host == null) {
            this.host = String.valueOf(uri.getPort());
        }
        if (this.serviceName == null) {
            String path = uri.getPath();
            if (path != null && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            this.serviceName = path;
        }
    }

    private void compose() {
        if (this.uri == null) {
            String path;
            int p = -1;
            if (this.port != null && this.port.length() > 0) {
                p = Integer.decode(this.port);
            }
            if ((path = this.serviceName) != null) {
                path = "/" + path;
            }
            try {
                this.uri = new URI("rmi", null, this.host, p, path, null, null).toString();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

