/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.jms.wireformat.jmstextxml.runtime;

import org.apache.axiom.om.OMElement;
import org.apache.tuscany.sca.assembly.AbstractContract;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.WebServiceBindingFactory;
import org.apache.tuscany.sca.binding.ws.wsdlgen.BindingWSDLGenerator;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import scallop.sca.binding.jms.impl.JMSBinding;
import scallop.sca.binding.jms.provider.JMSResourceFactory;
import scallop.sca.binding.jms.wireformat.jmstextxml.runtime.WireFormatJMSTextXMLServiceInterceptor;

public class WireFormatJMSTextXMLServiceProvider
implements WireFormatProvider {
    private ExtensionPointRegistry registry;
    private RuntimeComponent component;
    private RuntimeComponentService service;
    private JMSBinding binding;
    private JMSResourceFactory jmsResourceFactory;
    private InterfaceContract interfaceContract;

    public WireFormatJMSTextXMLServiceProvider(ExtensionPointRegistry registry, RuntimeComponent component, RuntimeComponentService service, Binding binding, JMSResourceFactory jmsResourceFactory) {
        this.component = component;
        this.service = service;
        this.binding = (JMSBinding)binding;
        this.jmsResourceFactory = jmsResourceFactory;
        if (this.binding.getRequestMessageProcessorName().equals("scallop.sca.binding.jms.provider.XMLTextMessageProcessor")) {
            this.binding.setRequestMessageProcessorName("scallop.sca.binding.jms.provider.XMLTextMessageProcessor");
            this.binding.setResponseMessageProcessorName("scallop.sca.binding.jms.provider.XMLTextMessageProcessor");
        }
        if (service.getInterfaceContract() != null && !this.isOnMessage()) {
            WebServiceBindingFactory wsFactory = (WebServiceBindingFactory)registry.getExtensionPoint(WebServiceBindingFactory.class);
            WebServiceBinding wsBinding = wsFactory.createWebServiceBinding();
            BindingWSDLGenerator.generateWSDL((Component)component, (AbstractContract)service, (WebServiceBinding)wsBinding, (ExtensionPointRegistry)registry, null);
            this.interfaceContract = wsBinding.getBindingInterfaceContract();
            this.interfaceContract.getInterface().resetDataBinding(OMElement.class.getName());
        } else {
            this.interfaceContract = service.getInterfaceContract();
        }
    }

    protected boolean isOnMessage() {
        InterfaceContract ic = this.service.getInterfaceContract();
        if (ic.getInterface().getOperations().size() != 1) {
            return false;
        }
        return "onMessage".equals(((Operation)ic.getInterface().getOperations().get(0)).getName());
    }

    public InterfaceContract getWireFormatInterfaceContract() {
        return this.interfaceContract;
    }

    public Interceptor createInterceptor() {
        return new WireFormatJMSTextXMLServiceInterceptor(this.binding, this.jmsResourceFactory, this.service.getRuntimeWire((Binding)this.binding));
    }

    public String getPhase() {
        return "service.binding.wireformat";
    }
}

