/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.jms.wireformat.jmstext.runtime;

import javax.jms.Session;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import scallop.sca.binding.jms.context.JMSBindingContext;
import scallop.sca.binding.jms.impl.JMSBinding;
import scallop.sca.binding.jms.provider.JMSMessageProcessor;
import scallop.sca.binding.jms.provider.JMSMessageProcessorUtil;
import scallop.sca.binding.jms.provider.JMSResourceFactory;
import scallop.sca.binding.jms.wireformat.jmstext.WireFormatJMSText;

public class WireFormatJMSTextServiceInterceptor
implements Interceptor {
    private Invoker next;
    private RuntimeWire runtimeWire;
    private JMSResourceFactory jmsResourceFactory;
    private JMSBinding jmsBinding;
    private JMSMessageProcessor requestMessageProcessor;
    private JMSMessageProcessor responseMessageProcessor;

    public WireFormatJMSTextServiceInterceptor(JMSBinding jmsBinding, JMSResourceFactory jmsResourceFactory, RuntimeWire runtimeWire) {
        this.jmsBinding = jmsBinding;
        this.runtimeWire = runtimeWire;
        this.jmsResourceFactory = jmsResourceFactory;
        this.requestMessageProcessor = JMSMessageProcessorUtil.getRequestMessageProcessor(jmsBinding);
        this.responseMessageProcessor = JMSMessageProcessorUtil.getResponseMessageProcessor(jmsBinding);
    }

    public Message invoke(Message msg) {
        if (this.jmsBinding.getRequestWireFormat() instanceof WireFormatJMSText) {
            msg = this.invokeRequest(msg);
        }
        msg = this.getNext().invoke(msg);
        if (this.jmsBinding.getResponseWireFormat() instanceof WireFormatJMSText) {
            msg = this.invokeResponse(msg);
        }
        return msg;
    }

    public Message invokeRequest(Message msg) {
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        javax.jms.Message jmsMsg = context.getJmsMsg();
        Object requestPayload = this.requestMessageProcessor.extractPayloadFromJMSMessage(jmsMsg);
        msg.setBody(requestPayload);
        return msg;
    }

    public Message invokeResponse(Message msg) {
        javax.jms.Message responseJMSMsg;
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        Session session = context.getJmsSession();
        if (msg.isFault()) {
            responseJMSMsg = this.responseMessageProcessor.createFaultMessage(session, (Throwable)msg.getBody());
        } else {
            Object[] response = new Object[]{msg.getBody()};
            responseJMSMsg = this.responseMessageProcessor.insertPayloadIntoJMSMessage(session, response);
        }
        msg.setBody((Object)responseJMSMsg);
        return msg;
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }
}

