/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.jms.transport;

import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.NamingException;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import scallop.sca.binding.jms.context.JMSBindingContext;
import scallop.sca.binding.jms.impl.JMSBinding;
import scallop.sca.binding.jms.impl.JMSBindingException;
import scallop.sca.binding.jms.provider.JMSMessageProcessor;
import scallop.sca.binding.jms.provider.JMSMessageProcessorUtil;
import scallop.sca.binding.jms.provider.JMSResourceFactory;

public class TransportReferenceInterceptor
implements Interceptor {
    private Invoker next;
    private RuntimeWire runtimeWire;
    private JMSResourceFactory jmsResourceFactory;
    private JMSBinding jmsBinding;
    private JMSMessageProcessor requestMessageProcessor;
    private JMSMessageProcessor responseMessageProcessor;
    private RuntimeComponentReference reference;

    public TransportReferenceInterceptor(JMSBinding jmsBinding, JMSResourceFactory jmsResourceFactory, RuntimeWire runtimeWire) {
        this.jmsBinding = jmsBinding;
        this.runtimeWire = runtimeWire;
        this.jmsResourceFactory = jmsResourceFactory;
        this.requestMessageProcessor = JMSMessageProcessorUtil.getRequestMessageProcessor(jmsBinding);
        this.responseMessageProcessor = JMSMessageProcessorUtil.getResponseMessageProcessor(jmsBinding);
        this.reference = (RuntimeComponentReference)runtimeWire.getSource().getContract();
    }

    public Message invoke(Message msg) {
        Message responseMsg = this.invokeRequest(msg);
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        if (context.getReplyToDestination() == null) {
            responseMsg.setBody(null);
        } else {
            responseMsg = this.invokeResponse(msg);
        }
        return responseMsg;
    }

    public Message invokeRequest(Message msg) {
        try {
            JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
            Session session = context.getJmsSession();
            MessageProducer producer = session.createProducer(context.getRequestDestination());
            if (this.jmsBinding.getOperationJMSTimeToLive(msg.getOperation().getName()) != null) {
                producer.setTimeToLive(this.jmsBinding.getOperationJMSTimeToLive(msg.getOperation().getName()).longValue());
            }
            try {
                producer.send((javax.jms.Message)msg.getBody());
            }
            finally {
                producer.close();
            }
            return msg;
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    public Message invokeResponse(Message msg) {
        try {
            javax.jms.Message replyMsg;
            JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
            Session session = context.getJmsSession();
            javax.jms.Message requestMessage = (javax.jms.Message)msg.getBody();
            String msgSelector = "JMSCorrelationID = '" + requestMessage.getJMSMessageID() + "'";
            MessageConsumer consumer = session.createConsumer(context.getReplyToDestination(), msgSelector);
            try {
                context.getJmsResourceFactory().startConnection();
                replyMsg = consumer.receive(context.getTimeToLive());
            }
            finally {
                consumer.close();
            }
            if (replyMsg == null) {
                throw new JMSBindingException("No reply message received on " + context.getReplyToDestination() + " for message id " + requestMessage.getJMSMessageID());
            }
            msg.setBody((Object)replyMsg);
            return msg;
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
        catch (NamingException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }
}

