/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.jms.provider;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.naming.NamingException;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import scallop.sca.binding.jms.context.JMSBindingContext;
import scallop.sca.binding.jms.impl.JMSBinding;
import scallop.sca.binding.jms.provider.JMSMessageProcessor;
import scallop.sca.binding.jms.provider.JMSMessageProcessorUtil;
import scallop.sca.binding.jms.provider.JMSResourceFactory;

public class RRBJMSBindingListener
implements MessageListener {
    private static final Logger logger = Logger.getLogger(RRBJMSBindingListener.class.getName());
    private JMSBinding jmsBinding;
    private Binding targetBinding;
    private JMSResourceFactory jmsResourceFactory;
    private RuntimeComponentService service;
    private JMSMessageProcessor requestMessageProcessor;
    private JMSMessageProcessor responseMessageProcessor;
    private String correlationScheme;
    private List<Operation> serviceOperations;
    private MessageFactory messageFactory;

    public RRBJMSBindingListener(JMSBinding jmsBinding, JMSResourceFactory jmsResourceFactory, RuntimeComponentService service, Binding targetBinding, MessageFactory messageFactory) throws NamingException {
        this.jmsBinding = jmsBinding;
        this.jmsResourceFactory = jmsResourceFactory;
        this.service = service;
        this.targetBinding = targetBinding;
        this.messageFactory = messageFactory;
        this.requestMessageProcessor = JMSMessageProcessorUtil.getRequestMessageProcessor(jmsBinding);
        this.responseMessageProcessor = JMSMessageProcessorUtil.getResponseMessageProcessor(jmsBinding);
        this.correlationScheme = jmsBinding.getCorrelationScheme();
        this.serviceOperations = service.getInterfaceContract().getInterface().getOperations();
    }

    public void onMessage(javax.jms.Message requestJMSMsg) {
        logger.log(Level.FINE, "JMS service '" + this.service.getName() + "' received message " + requestJMSMsg);
        try {
            this.invokeService(requestJMSMsg);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Exception send fault response '" + this.service.getName(), e);
        }
    }

    protected void invokeService(javax.jms.Message requestJMSMsg) throws JMSException, InvocationTargetException {
        Message tuscanyMsg = this.messageFactory.createMessage();
        JMSBindingContext context = new JMSBindingContext();
        tuscanyMsg.setBindingContext((Object)context);
        context.setJmsMsg(requestJMSMsg);
        context.setJmsResourceFactory(this.jmsResourceFactory);
        context.setReplyToDestination(requestJMSMsg.getJMSReplyTo());
        tuscanyMsg.setBody((Object)requestJMSMsg);
        this.service.getRuntimeWire(this.targetBinding).invoke(tuscanyMsg);
    }
}

