/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.jms.provider;

import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.provider.BindingProviderFactory;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.work.WorkScheduler;
import scallop.sca.binding.jms.impl.JMSBinding;
import scallop.sca.binding.jms.provider.DefaultJMSResourceFactoryExtensionPoint;
import scallop.sca.binding.jms.provider.JMSBindingReferenceBindingProvider;
import scallop.sca.binding.jms.provider.JMSBindingServiceBindingProvider;
import scallop.sca.binding.jms.provider.JMSResourceFactory;
import scallop.sca.binding.jms.provider.JMSResourceFactoryExtensionPoint;

public class JMSBindingProviderFactory
implements BindingProviderFactory<JMSBinding> {
    private WorkScheduler workScheduler;
    private ExtensionPointRegistry extensionPoints;
    private JMSResourceFactoryExtensionPoint jmsRFEP;

    public JMSBindingProviderFactory(ExtensionPointRegistry extensionPoints) {
        this.extensionPoints = extensionPoints;
        UtilityExtensionPoint utilities = (UtilityExtensionPoint)extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        this.workScheduler = (WorkScheduler)utilities.getUtility(WorkScheduler.class);
        this.jmsRFEP = (JMSResourceFactoryExtensionPoint)extensionPoints.getExtensionPoint(JMSResourceFactoryExtensionPoint.class);
        if (this.jmsRFEP == null) {
            this.jmsRFEP = new DefaultJMSResourceFactoryExtensionPoint();
            extensionPoints.addExtensionPoint((Object)this.jmsRFEP);
        }
    }

    public ReferenceBindingProvider createReferenceBindingProvider(RuntimeComponent component, RuntimeComponentReference reference, JMSBinding binding) {
        JMSResourceFactory jmsRF = this.jmsRFEP.createJMSResourceFactory(binding);
        return new JMSBindingReferenceBindingProvider(component, reference, binding, this.extensionPoints, jmsRF);
    }

    public ServiceBindingProvider createServiceBindingProvider(RuntimeComponent component, RuntimeComponentService service, JMSBinding binding) {
        JMSResourceFactory jmsRF = this.jmsRFEP.createJMSResourceFactory(binding);
        return new JMSBindingServiceBindingProvider(component, service, (Binding)binding, binding, this.workScheduler, this.extensionPoints, jmsRF);
    }

    public Class<JMSBinding> getModelType() {
        return JMSBinding.class;
    }
}

