/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.jms.provider;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.NamingException;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.core.assembly.EndpointReferenceImpl;
import org.apache.tuscany.sca.core.invocation.MessageImpl;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.EndpointReference;
import org.apache.tuscany.sca.runtime.ReferenceParameters;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import scallop.sca.binding.jms.impl.JMSBinding;
import scallop.sca.binding.jms.impl.JMSBindingException;
import scallop.sca.binding.jms.provider.JMSMessageProcessor;
import scallop.sca.binding.jms.provider.JMSMessageProcessorUtil;
import scallop.sca.binding.jms.provider.JMSResourceFactory;

@Deprecated
public class DefaultJMSBindingListener
implements MessageListener {
    private static final Logger logger = Logger.getLogger(DefaultJMSBindingListener.class.getName());
    private static final String ON_MESSAGE_METHOD_NAME = "onMessage";
    private JMSBinding jmsBinding;
    private Binding targetBinding;
    private JMSResourceFactory jmsResourceFactory;
    private RuntimeComponentService service;
    private JMSMessageProcessor requestMessageProcessor;
    private JMSMessageProcessor responseMessageProcessor;
    private String correlationScheme;
    private List<Operation> serviceOperations;

    public DefaultJMSBindingListener(JMSBinding jmsBinding, JMSResourceFactory jmsResourceFactory, RuntimeComponentService service, Binding targetBinding) throws NamingException {
        this.jmsBinding = jmsBinding;
        this.jmsResourceFactory = jmsResourceFactory;
        this.service = service;
        this.targetBinding = targetBinding;
        this.requestMessageProcessor = JMSMessageProcessorUtil.getRequestMessageProcessor(jmsBinding);
        this.responseMessageProcessor = JMSMessageProcessorUtil.getResponseMessageProcessor(jmsBinding);
        this.correlationScheme = jmsBinding.getCorrelationScheme();
        this.serviceOperations = service.getInterfaceContract().getInterface().getOperations();
    }

    public void onMessage(javax.jms.Message requestJMSMsg) {
        logger.log(Level.FINE, "JMS service '" + this.service.getName() + "' received message " + requestJMSMsg);
        try {
            Object responsePayload = this.invokeService(requestJMSMsg);
            this.sendReply(requestJMSMsg, responsePayload, false);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Exception invoking service '" + this.service.getName(), e);
            this.sendReply(requestJMSMsg, e, true);
        }
    }

    protected Object invokeService(javax.jms.Message requestJMSMsg) throws JMSException, InvocationTargetException {
        String operationName = this.requestMessageProcessor.getOperationName(requestJMSMsg);
        Operation operation = this.getTargetOperation(operationName);
        MessageImpl tuscanyMsg = new MessageImpl();
        tuscanyMsg.setOperation(operation);
        if (ON_MESSAGE_METHOD_NAME.equals(operation.getName())) {
            tuscanyMsg.setBody((Object)new Object[]{requestJMSMsg});
        } else {
            Object requestPayload = this.requestMessageProcessor.extractPayloadFromJMSMessage(requestJMSMsg);
            tuscanyMsg.setBody(requestPayload);
        }
        this.setHeaderProperties(requestJMSMsg, tuscanyMsg, operation);
        return this.service.getRuntimeWire(this.targetBinding).invoke(operation, (Message)tuscanyMsg);
    }

    protected Operation getTargetOperation(String operationName) {
        Operation operation = null;
        if (this.serviceOperations.size() == 1) {
            operation = this.serviceOperations.get(0);
        } else if (operationName != null) {
            for (Operation op : this.serviceOperations) {
                if (!op.getName().equals(operationName)) continue;
                operation = op;
                break;
            }
        } else {
            for (Operation op : this.serviceOperations) {
                if (!op.getName().equals(ON_MESSAGE_METHOD_NAME)) continue;
                operation = op;
                break;
            }
        }
        if (operation == null) {
            throw new JMSBindingException("Can't find operation " + (operationName != null ? operationName : ON_MESSAGE_METHOD_NAME));
        }
        return operation;
    }

    protected void setHeaderProperties(javax.jms.Message requestJMSMsg, MessageImpl tuscanyMsg, Operation operation) throws JMSException {
        EndpointReferenceImpl from = new EndpointReferenceImpl(null);
        tuscanyMsg.setFrom((EndpointReference)from);
        from.setCallbackEndpoint((EndpointReference)new EndpointReferenceImpl("/"));
        ReferenceParameters parameters = from.getReferenceParameters();
        String conversationID = requestJMSMsg.getStringProperty("scaConversationId");
        if (conversationID != null) {
            parameters.setConversationID((Object)conversationID);
        }
        if (this.service.getInterfaceContract().getCallbackInterface() != null) {
            String callbackID;
            Destination replyTo;
            String callbackdestName = requestJMSMsg.getStringProperty("scaCallbackQueue ");
            if (callbackdestName == null && operation.isNonBlocking() && (replyTo = requestJMSMsg.getJMSReplyTo()) != null) {
                String string = callbackdestName = replyTo instanceof Queue ? ((Queue)replyTo).getQueueName() : ((Topic)replyTo).getTopicName();
            }
            if (callbackdestName != null) {
                parameters.setCallbackReference((EndpointReference)new EndpointReferenceImpl("jms:" + callbackdestName));
            }
            if ((callbackID = requestJMSMsg.getStringProperty("CallbackID")) != null) {
                parameters.setCallbackID((Object)callbackID);
            }
        }
    }

    protected void sendReply(javax.jms.Message requestJMSMsg, Object responsePayload, boolean isFault) {
        try {
            if (requestJMSMsg.getJMSReplyTo() == null) {
                if (responsePayload != null) {
                    logger.log(Level.FINE, "JMS service '" + this.service.getName() + "' dropped response as request has no replyTo");
                }
                return;
            }
            Session session = this.jmsResourceFactory.createSession();
            javax.jms.Message replyJMSMsg = isFault ? this.responseMessageProcessor.createFaultMessage(session, (Throwable)responsePayload) : this.responseMessageProcessor.insertPayloadIntoJMSMessage(session, responsePayload);
            replyJMSMsg.setJMSDeliveryMode(requestJMSMsg.getJMSDeliveryMode());
            replyJMSMsg.setJMSPriority(requestJMSMsg.getJMSPriority());
            if (this.correlationScheme == null || "requestmsgidtocorrelid".equalsIgnoreCase(this.correlationScheme)) {
                replyJMSMsg.setJMSCorrelationID(requestJMSMsg.getJMSMessageID());
            } else if ("requestcorrelidtocorrelid".equalsIgnoreCase(this.correlationScheme)) {
                replyJMSMsg.setJMSCorrelationID(requestJMSMsg.getJMSCorrelationID());
            }
            Destination destination = requestJMSMsg.getJMSReplyTo();
            MessageProducer producer = session.createProducer(destination);
            producer.send(replyJMSMsg);
            producer.close();
            session.close();
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
        catch (NamingException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }
}

