/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.jms.provider;

import java.lang.reflect.InvocationTargetException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.naming.NamingException;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.FaultException;
import org.apache.tuscany.sca.invocation.DataExchangeSemantics;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.osoa.sca.ServiceRuntimeException;
import scallop.sca.binding.jms.context.JMSBindingContext;
import scallop.sca.binding.jms.impl.JMSBinding;
import scallop.sca.binding.jms.impl.JMSBindingException;
import scallop.sca.binding.jms.provider.JMSMessageProcessor;
import scallop.sca.binding.jms.provider.JMSMessageProcessorUtil;
import scallop.sca.binding.jms.provider.JMSResourceFactory;

public class RRBJMSBindingInvoker
implements Invoker,
DataExchangeSemantics {
    protected Operation operation;
    protected String operationName;
    protected JMSBinding jmsBinding;
    protected JMSResourceFactory jmsResourceFactory;
    protected JMSMessageProcessor requestMessageProcessor;
    protected JMSMessageProcessor responseMessageProcessor;
    protected Destination bindingRequestDest;
    protected Destination bindingReplyDest;
    protected RuntimeComponentReference reference;
    protected RuntimeWire runtimeWire;

    public RRBJMSBindingInvoker(JMSBinding jmsBinding, Operation operation, JMSResourceFactory jmsResourceFactory, RuntimeComponentReference reference) {
        this.operation = operation;
        this.operationName = operation.getName();
        this.jmsBinding = jmsBinding;
        this.jmsResourceFactory = jmsResourceFactory;
        this.reference = reference;
        this.runtimeWire = reference.getRuntimeWire((Binding)jmsBinding);
        this.requestMessageProcessor = JMSMessageProcessorUtil.getRequestMessageProcessor(jmsBinding);
        this.responseMessageProcessor = JMSMessageProcessorUtil.getResponseMessageProcessor(jmsBinding);
        try {
            this.bindingRequestDest = this.lookupDestination();
            this.bindingReplyDest = this.lookupResponseDestination();
        }
        catch (NamingException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    protected Destination lookupDestination() throws NamingException, JMSBindingException {
        return this.lookupDestinationQueue(false);
    }

    protected Destination lookupResponseDestination() throws NamingException, JMSBindingException {
        return this.lookupDestinationQueue(true);
    }

    protected Destination lookupDestinationQueue(boolean isReponseQueue) throws NamingException, JMSBindingException {
        String qCreateMode;
        String queueType;
        String queueName;
        if (isReponseQueue) {
            queueName = this.jmsBinding.getResponseDestinationName();
            queueType = "JMS Response Destination ";
            qCreateMode = this.jmsBinding.getResponseDestinationCreate();
            if ("NORESPONSEDESTINATION".equals(queueName)) {
                return null;
            }
        } else {
            queueName = this.jmsBinding.getDestinationName();
            queueType = "JMS Destination ";
            qCreateMode = this.jmsBinding.getDestinationCreate();
        }
        Destination dest = this.jmsResourceFactory.lookupDestination(queueName);
        if (qCreateMode.equals("always")) {
            if (dest != null) {
                throw new JMSBindingException(String.valueOf(queueType) + queueName + " already exists but has create mode of \"" + qCreateMode + "\" while registering binding " + this.jmsBinding.getName() + " invoker");
            }
            dest = this.jmsResourceFactory.createDestination(queueName);
        } else if (qCreateMode.equals("ifnotexist")) {
            if (dest == null) {
                dest = this.jmsResourceFactory.createDestination(queueName);
            }
        } else if (qCreateMode.equals("never") && dest == null) {
            throw new JMSBindingException(String.valueOf(queueType) + queueName + " not found but create mode of \"" + qCreateMode + "\" while registering binding " + this.jmsBinding.getName() + " invoker");
        }
        if (dest == null) {
            throw new JMSBindingException(String.valueOf(queueType) + queueName + " not found with create mode of \"" + qCreateMode + "\" while registering binding " + this.jmsBinding.getName() + " invoker");
        }
        return dest;
    }

    /*
     * Loose catch block
     */
    public Message invoke(Message tuscanyMsg) {
        try {
            Session session = this.jmsResourceFactory.createSession();
            JMSBindingContext context = new JMSBindingContext();
            tuscanyMsg.setBindingContext((Object)context);
            context.setJmsSession(session);
            context.setRequestDestination(this.getRequestDestination(tuscanyMsg, session));
            context.setReplyToDestination(this.getReplyToDestination(session));
            context.setJmsResourceFactory(this.jmsResourceFactory);
            try {
                try {
                    tuscanyMsg = this.runtimeWire.getBindingInvocationChain().getHeadInvoker().invoke(tuscanyMsg);
                }
                catch (ServiceRuntimeException e) {
                    if (e.getCause() instanceof InvocationTargetException) {
                        if (e.getCause().getCause() instanceof RuntimeException) {
                            tuscanyMsg.setFaultBody((Object)e.getCause());
                        } else {
                            tuscanyMsg.setFaultBody((Object)((InvocationTargetException)e.getCause()).getTargetException());
                        }
                    } else if (e.getCause() instanceof FaultException) {
                        tuscanyMsg.setFaultBody((Object)e.getCause());
                    } else {
                        tuscanyMsg.setFaultBody((Object)e);
                    }
                    session.close();
                }
                catch (IllegalStateException e) {
                    tuscanyMsg.setFaultBody((Object)e);
                    session.close();
                }
                catch (Throwable e) {
                    tuscanyMsg.setFaultBody((Object)e);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    session.close();
                }
            }
            finally {
                session.close();
            }
            return tuscanyMsg;
        }
        catch (Exception e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    protected Destination getRequestDestination(Message tuscanyMsg, Session session) throws JMSBindingException, NamingException, JMSException {
        String toURI;
        Object requestDestination = this.reference.isCallback() ? ((toURI = tuscanyMsg.getTo().getURI()) != null && toURI.startsWith("jms:") ? session.createQueue(toURI.substring(4)) : this.lookupDestination()) : this.bindingRequestDest;
        return requestDestination;
    }

    protected Destination getReplyToDestination(Session session) throws JMSException, JMSBindingException, NamingException {
        Object replyToDest = this.operation.isNonBlocking() ? null : (this.bindingReplyDest != null ? this.bindingReplyDest : session.createTemporaryQueue());
        return replyToDest;
    }

    public boolean allowsPassByReference() {
        return true;
    }
}

