/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.jms.provider;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import scallop.sca.binding.jms.impl.JMSBinding;
import scallop.sca.binding.jms.impl.JMSBindingException;
import scallop.sca.binding.jms.provider.AbstractMessageProcessor;

public class BytesMessageProcessor
extends AbstractMessageProcessor {
    public BytesMessageProcessor(JMSBinding jmsBinding) {
        super(jmsBinding);
    }

    @Override
    protected Object[] extractPayload(Message msg) {
        try {
            if (!(msg instanceof BytesMessage)) {
                throw new IllegalStateException("expecting JMS BytesMessage: " + msg);
            }
            long noOfBytes = ((BytesMessage)msg).getBodyLength();
            byte[] bytes = new byte[(int)noOfBytes];
            ((BytesMessage)msg).readBytes(bytes);
            return new Object[]{bytes};
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    @Override
    protected Message createJMSMessage(Session session, Object o) {
        try {
            BytesMessage message = session.createBytesMessage();
            byte[] bytes = (byte[])((Object[])o)[0];
            message.writeBytes(bytes);
            return message;
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }
}

