/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import org.apache.commons.pool.BasePoolableObjectFactory;
import redis.clients.jedis.Jedis;

class JedisFactory
extends BasePoolableObjectFactory {
    private final String host;
    private final int port;
    private final int timeout;
    private final String password;
    private final int database;

    public JedisFactory(String host, int port, int timeout, String password, int database) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.password = password;
        this.database = database;
    }

    public Object makeObject() throws Exception {
        Jedis jedis = new Jedis(this.host, this.port, this.timeout);
        jedis.connect();
        if (null != this.password) {
            jedis.auth(this.password);
        }
        if (this.database != 0) {
            jedis.select(this.database);
        }
        return jedis;
    }

    public void activateObject(Object obj) throws Exception {
        Jedis jedis;
        if (obj instanceof Jedis && (jedis = (Jedis)obj).getDB() != (long)this.database) {
            jedis.select(this.database);
        }
    }

    public void destroyObject(Object obj) throws Exception {
        Jedis jedis;
        if (obj instanceof Jedis && (jedis = (Jedis)obj).isConnected()) {
            try {
                try {
                    jedis.quit();
                }
                catch (Exception e) {
                    // empty catch block
                }
                jedis.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean validateObject(Object obj) {
        if (obj instanceof Jedis) {
            Jedis jedis = (Jedis)obj;
            try {
                return jedis.isConnected() && jedis.ping().equals("PONG");
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }
}

