-- ----------------------------
-- Table structure for `user`
-- ----------------------------
-- DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `pwd` varchar(20) NOT NULL  ,  
    `alias` varchar(20)   ,  
    `name` varchar(20)   ,  
    `img` varchar(20)   ,  
    `pay_pwd` varchar(20)   ,  
    `type` int NOT NULL  ,  
    `risk` int NOT NULL  ,  
    `acc_status` int NOT NULL  ,  
    `auth_status` int NOT NULL  ,  
    `credit_lines` float NOT NULL  ,  
    `score` float NOT NULL  ,  
    `register_at` bigint NOT NULL  ,  
    `last_login_at` bigint NOT NULL  ,  
    `status` bigint NOT NULL  ,  
    `wrong_count` int NOT NULL  ,  
    `fund_account` varchar(50)   ,  
    `card_status` int NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `person`
-- ----------------------------
-- DROP TABLE IF EXISTS `person`;
CREATE TABLE `person` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `id_no` varchar(20) NOT NULL  ,  
    `name` varchar(20) NOT NULL  ,  
    `id_front` varchar(100) NOT NULL  ,  
    `id_back` varchar(100) NOT NULL  ,  
    `person_id_img` varchar(100) NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `organization`
-- ----------------------------
-- DROP TABLE IF EXISTS `organization`;
CREATE TABLE `organization` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `licence_img` varchar(100)   ,  
    `permit_img` varchar(100)   ,  
    `tax_img` varchar(100)   ,  
    `org_code` varchar(20) NOT NULL  ,  
    `licence_code` varchar(20)   ,  
    `credit_code` varchar(20)   ,  
    `type` int   ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `orgApply`
-- ----------------------------
-- DROP TABLE IF EXISTS `orgApply`;
CREATE TABLE `orgApply` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `uid` bigint NOT NULL  ,  
    `name` varchar(50) NOT NULL  ,  
    `licence_img` varchar(100)   ,  
    `permit_img` varchar(100)   ,  
    `tax_img` varchar(100)   ,  
    `org_code` varchar(20)   ,  
    `licence_code` varchar(20)   ,  
    `credit_code` varchar(20)   ,  
    `pay_pwd` varchar(20)   ,  
    `bank` varchar(50)   ,  
    `card_no` varchar(20)   ,  
    `status` int   ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `personApply`
-- ----------------------------
-- DROP TABLE IF EXISTS `personApply`;
CREATE TABLE `personApply` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `uid` bigint NOT NULL  ,  
    `id_no` varchar(20) NOT NULL  ,  
    `name` varchar(20) NOT NULL  ,  
    `id_front` varchar(100) NOT NULL  ,  
    `id_back` varchar(100) NOT NULL  ,  
    `person_id_img` varchar(100) NOT NULL  ,  
    `status` int NOT NULL  ,
    `refuse_reason` text  NULL  ,
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,
    `check_at` bigint NOT NULL  ,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `scoreHistory`
-- ----------------------------
-- DROP TABLE IF EXISTS `scoreHistory`;
CREATE TABLE `scoreHistory` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `uid` bigint NOT NULL  ,  
    `income` varchar(20)   ,  
    `expenditure` varchar(20)   ,  
    `total` bigint NOT NULL  ,  
    `comment` text   ,  
    `deal_at` bigint NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user_openid_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_openid_relation`;
CREATE TABLE `user_openid_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `uid` bigint NOT NULL  ,  
    `openid` varchar(50) NOT NULL  ,  
    `type` int NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;



-- ----------------------------
-- Table structure for `personApplyRecord`
-- ----------------------------
-- DROP TABLE IF EXISTS `personApplyRecord`;
CREATE TABLE `personApplyRecord` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,
    `personapply_id` bigint NOT NULL  ,
    `number` varchar(20) NOT NULL  ,
    `status` int NOT NULL  ,
    `operator` varchar(200) NOT NULL  ,
    `description` text   ,
    `create_by` bigint NOT NULL  ,
    `update_by` bigint   ,
    `update_at` bigint NOT NULL  ,
    `create_at` bigint NOT NULL  ,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for `orgApplyRecord`
-- ----------------------------
-- DROP TABLE IF EXISTS `orgApplyRecord`;
CREATE TABLE `orgApplyRecord` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,
    `orgapply_id` bigint NOT NULL  ,
    `number` varchar(20) NOT NULL  ,
    `status` int NOT NULL  ,
    `operator` varchar(200) NOT NULL  ,
    `description` text   ,
    `create_by` bigint NOT NULL  ,
    `update_by` bigint   ,
    `update_at` bigint NOT NULL  ,
    `create_at` bigint NOT NULL  ,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;







