/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.wealth.user.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.gemantic.dal.id.util.SequenceService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.consign.constant.OpEntrustWayEnum;
import com.ptteng.wealth.consign.model.in.AutoDocBailRechargeIn;
import com.ptteng.wealth.consign.model.in.BindingBankIn;
import com.ptteng.wealth.consign.model.out.AutoDocBailRechargeOut;
import com.ptteng.wealth.consign.model.out.BindingBank;
import com.ptteng.wealth.consign.service.ConsignmentService;
import com.ptteng.wealth.finance.model.Fund;
import com.ptteng.wealth.finance.model.account.Account;
import com.ptteng.wealth.finance.model.account.UserAccountRelation;
import com.ptteng.wealth.finance.service.FundService;
import com.ptteng.wealth.finance.service.account.AccountService;
import com.ptteng.wealth.finance.service.account.UserAccountRelationService;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.service.PersonService;
import com.ptteng.wealth.user.service.UserService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component(value="UserService")
public class UserServiceImpl
extends BaseDaoServiceImpl
implements UserService {
    private static final Log log = LogFactory.getLog(UserServiceImpl.class);
    private PersonService personService;
    private FundService fundService;
    private AccountService accountService;
    private UserAccountRelationService userAccountRelationService;
    private ConsignmentService consignmentService;

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public FundService getFundService() {
        return this.fundService;
    }

    public void setFundService(FundService fundService) {
        this.fundService = fundService;
    }

    public AccountService getAccountService() {
        return this.accountService;
    }

    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    public UserAccountRelationService getUserAccountRelationService() {
        return this.userAccountRelationService;
    }

    public void setUserAccountRelationService(UserAccountRelationService userAccountRelationService) {
        this.userAccountRelationService = userAccountRelationService;
    }

    public boolean pay(Long userId, BigDecimal payMoney) throws ServiceException, ServiceDaoException {
        boolean bPay = false;
        User user = this.getObjectById(userId);
        BindingBank bindingBank = null;
        try {
            BindingBankIn bindingBankIn = new BindingBankIn();
            bindingBankIn.setFunctionId(9534);
            bindingBankIn.setUserId("1980120910");
            bindingBankIn.setFundAccount(880294775);
            bindingBankIn.setBranchNo(88);
            List bindingBanks = this.consignmentService.getBindingBanks(bindingBankIn);
            for (BindingBank bindingBank1 : bindingBanks) {
                if (!bindingBank1.getMainFlag().equals("1")) continue;
                bindingBank = bindingBank1;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        AutoDocBailRechargeIn organBindCardIn = new AutoDocBailRechargeIn();
        organBindCardIn.setFunctionId(9751);
        organBindCardIn.setUserId(user.getId() + "");
        organBindCardIn.setFundAccount(user.getFundAccount().intValue());
        organBindCardIn.setPassword(user.getPayPwd());
        organBindCardIn.setBranchNo(88);
        organBindCardIn.setFundAccountG(user.getFundAccount().intValue());
        organBindCardIn.setFundAccountB(user.getFundAccount().intValue());
        organBindCardIn.setOpbusinessFlag("8035");
        organBindCardIn.setOccurBalanceG(payMoney);
        organBindCardIn.setTiedCardType("0");
        organBindCardIn.setMoneyType("1");
        organBindCardIn.setFundCompany("9999");
        organBindCardIn.setFundCode("990006");
        organBindCardIn.setPayType("0");
        organBindCardIn.setChannelResource("");
        organBindCardIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
        organBindCardIn.setBankNoDk(bindingBank.getBankNo());
        organBindCardIn.setBankAccountDk(bindingBank.getBankAccount());
        organBindCardIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
        try {
            AutoDocBailRechargeOut autoDocBailRechargeOut = this.consignmentService.autoDocBailRecharge(organBindCardIn);
            log.info((Object)(" pay result : " + autoDocBailRechargeOut));
            if (0 == autoDocBailRechargeOut.getErrorNo()) {
                bPay = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return bPay;
    }

    public Long insert(User user) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + user));
        if (user == null) {
            return null;
        }
        Long result = null;
        try {
            long currentTimeMillis = System.currentTimeMillis();
            user.setCreateAt(Long.valueOf(currentTimeMillis));
            user.setUpdateAt(Long.valueOf(currentTimeMillis));
            result = (Long)this.dao.save((Object)user);
            log.info((Object)(" \u521b\u5efa\u7528\u6237:" + user.getId() + "\u540c\u6b65\u4fe1\u606f\u8868\u6d41\u7a0b "));
            log.info((Object)"==========\u7b2c\u4e8c\u6b65\uff1a\u751f\u6210\u8d44\u4ea7\u4fe1\u606f\u8868==========");
            Fund fund = new Fund();
            fund.setId(result);
            Long fundId = this.fundService.insert(fund);
            log.info((Object)("  fundId = " + fundId));
            log.info((Object)"==========\u7b2c\u4e09\u6b65\uff1a\u751f\u6210\u5f00\u78f7\u8d26\u6237\u4fe1\u606f\u8868==========");
            List ids = this.accountService.getAccountIds(Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            List accounts = this.accountService.getObjectsByIds(ids);
            log.info((Object)"==========\u7b2c\u56db\u6b65\uff1a\u63d2\u5165\u7528\u6237\u4fe1\u606f\u8868==========");
            UserAccountRelation userAccountRelation = new UserAccountRelation();
            for (Account account : accounts) {
                userAccountRelation.setUserId(user.getId());
                userAccountRelation.setAccountCode(account.getAccCode());
                userAccountRelation.setAccountId(account.getId());
                userAccountRelation.setMoney(new BigDecimal("0"));
                this.userAccountRelationService.insert(userAccountRelation);
            }
            log.info((Object)"==========\u7b2c\u4e94\u6b65\uff1a\u63d2\u5165\u7528\u6237\u4fe1\u606f\u8868==========");
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + user));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public Long insertUser(User user) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + user));
        if (user == null) {
            return null;
        }
        Long result = null;
        try {
            long currentTimeMillis = System.currentTimeMillis();
            user.setCreateAt(Long.valueOf(currentTimeMillis));
            user.setUpdateAt(Long.valueOf(currentTimeMillis));
            result = (Long)this.dao.save((Object)user);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + user));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public Long getLatestUserId() throws ServiceException, ServiceDaoException {
        return SequenceService.getInstance().nextValue("wealthUser");
    }

    public List<User> insertList(List<User> userList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (userList == null ? "null" : Integer.valueOf(userList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(userList)) {
            return new ArrayList<User>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (User user : userList) {
            user.setCreateAt(Long.valueOf(currentTimeMillis));
            user.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(userList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + userList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(User.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(User user) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (user == null ? "null" : user.getId())));
        boolean result = false;
        if (user == null) {
            return true;
        }
        user.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)user);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + user));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + user));
        }
        return result;
    }

    public boolean updateList(List<User> userList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (userList == null ? "null" : Integer.valueOf(userList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(userList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (User user : userList) {
            user.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(userList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + userList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + userList.size()));
        return result;
    }

    public User getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        User user = null;
        if (id == null) {
            return user;
        }
        try {
            user = (User)this.dao.get(User.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return user;
    }

    public List<User> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List user = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<User>();
        }
        try {
            user = this.dao.getList(User.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (user == null ? "null" : Integer.valueOf(user.size()))));
        return user;
    }

    public List<Long> getUserIdsByType(Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by type,start,limit  : " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserIdsByType", new Object[]{type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by type,start,limit)  : " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserIdsByType(Integer type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by type  : " + type));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUserIdsByType", new Object[]{type});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by type)  : " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getUserIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getUserIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getUserIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public Long getUserIdByMobile(String mobile) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get id by mobile  : " + mobile));
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserIdByMobile", new Object[]{mobile});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by mobile  : " + mobile));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Long getUserIdByKailinCode(String kailinCode) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get id by kailinCode  : " + kailinCode));
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserIdByKailinCode", new Object[]{kailinCode});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by kailinCode  : " + kailinCode));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public ConsignmentService getConsignmentService() {
        return this.consignmentService;
    }

    public void setConsignmentService(ConsignmentService consignmentService) {
        this.consignmentService = consignmentService;
    }
}

