/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.wealth.user.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.user.model.ScoreHistory;
import com.ptteng.wealth.user.service.ScoreHistoryService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScoreHistoryServiceImpl
extends BaseDaoServiceImpl
implements ScoreHistoryService {
    private static final Log log = LogFactory.getLog(ScoreHistoryServiceImpl.class);

    public Long insert(ScoreHistory scoreHistory) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + scoreHistory));
        if (scoreHistory == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        scoreHistory.setCreateAt(Long.valueOf(currentTimeMillis));
        scoreHistory.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)scoreHistory);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + scoreHistory));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<ScoreHistory> insertList(List<ScoreHistory> scoreHistoryList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (scoreHistoryList == null ? "null" : Integer.valueOf(scoreHistoryList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(scoreHistoryList)) {
            return new ArrayList<ScoreHistory>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ScoreHistory scoreHistory : scoreHistoryList) {
            scoreHistory.setCreateAt(Long.valueOf(currentTimeMillis));
            scoreHistory.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(scoreHistoryList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + scoreHistoryList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(ScoreHistory.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(ScoreHistory scoreHistory) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (scoreHistory == null ? "null" : scoreHistory.getId())));
        boolean result = false;
        if (scoreHistory == null) {
            return true;
        }
        scoreHistory.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)scoreHistory);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + scoreHistory));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + scoreHistory));
        }
        return result;
    }

    public boolean updateList(List<ScoreHistory> scoreHistoryList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (scoreHistoryList == null ? "null" : Integer.valueOf(scoreHistoryList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(scoreHistoryList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ScoreHistory scoreHistory : scoreHistoryList) {
            scoreHistory.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(scoreHistoryList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + scoreHistoryList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + scoreHistoryList.size()));
        return result;
    }

    public ScoreHistory getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        ScoreHistory scoreHistory = null;
        if (id == null) {
            return scoreHistory;
        }
        try {
            scoreHistory = (ScoreHistory)this.dao.get(ScoreHistory.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return scoreHistory;
    }

    public List<ScoreHistory> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List scoreHistory = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<ScoreHistory>();
        }
        try {
            scoreHistory = this.dao.getList(ScoreHistory.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (scoreHistory == null ? "null" : Integer.valueOf(scoreHistory.size()))));
        return scoreHistory;
    }

    public Long getScoreHistoryIdByUid(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by uid  : " + uid));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getScoreHistoryIdByUid", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by uid  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getScoreHistoryIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getScoreHistoryIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countScoreHistoryIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getScoreHistoryIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getScoreHistoryIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

