/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.wealth.user.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.user.model.Person;
import com.ptteng.wealth.user.service.PersonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersonServiceImpl
extends BaseDaoServiceImpl
implements PersonService {
    private static final Log log = LogFactory.getLog(PersonServiceImpl.class);

    public Long insert(Person person) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + person));
        if (person == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        person.setCreateAt(Long.valueOf(currentTimeMillis));
        person.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)person);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + person));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Person> insertList(List<Person> personList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (personList == null ? "null" : Integer.valueOf(personList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(personList)) {
            return new ArrayList<Person>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Person person : personList) {
            person.setCreateAt(Long.valueOf(currentTimeMillis));
            person.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(personList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + personList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Person.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Person person) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (person == null ? "null" : person.getId())));
        boolean result = false;
        if (person == null) {
            return true;
        }
        person.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)person);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + person));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + person));
        }
        return result;
    }

    public boolean updateList(List<Person> personList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (personList == null ? "null" : Integer.valueOf(personList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(personList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Person person : personList) {
            person.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(personList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + personList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + personList.size()));
        return result;
    }

    public Person getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Person person = null;
        if (id == null) {
            return person;
        }
        try {
            person = (Person)this.dao.get(Person.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return person;
    }

    public List<Person> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List person = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Person>();
        }
        try {
            person = this.dao.getList(Person.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (person == null ? "null" : Integer.valueOf(person.size()))));
        return person;
    }

    public List<Long> getPersonIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPersonIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countPersonIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getPersonIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getPersonIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

