/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.wealth.user.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.user.model.Organization;
import com.ptteng.wealth.user.service.OrganizationService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component(value="OrganizationService")
public class OrganizationServiceImpl
extends BaseDaoServiceImpl
implements OrganizationService {
    private static final Log log = LogFactory.getLog(OrganizationServiceImpl.class);

    public Long insert(Organization organization) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + organization));
        if (organization == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        organization.setCreateAt(Long.valueOf(currentTimeMillis));
        organization.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)organization);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + organization));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Organization> insertList(List<Organization> organizationList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (organizationList == null ? "null" : Integer.valueOf(organizationList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(organizationList)) {
            return new ArrayList<Organization>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Organization organization : organizationList) {
            organization.setCreateAt(Long.valueOf(currentTimeMillis));
            organization.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(organizationList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + organizationList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Organization.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Organization organization) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (organization == null ? "null" : organization.getId())));
        boolean result = false;
        if (organization == null) {
            return true;
        }
        organization.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)organization);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + organization));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + organization));
        }
        return result;
    }

    public boolean updateList(List<Organization> organizationList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (organizationList == null ? "null" : Integer.valueOf(organizationList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(organizationList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Organization organization : organizationList) {
            organization.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(organizationList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + organizationList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + organizationList.size()));
        return result;
    }

    public Organization getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Organization organization = null;
        if (id == null) {
            return organization;
        }
        try {
            organization = (Organization)this.dao.get(Organization.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return organization;
    }

    public List<Organization> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List organization = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Organization>();
        }
        try {
            organization = this.dao.getList(Organization.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (organization == null ? "null" : Integer.valueOf(organization.size()))));
        return organization;
    }

    public List<Long> getOrganizationIdsByType(Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by type,start,limit  : " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getOrganizationIdsByType", new Object[]{type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by type,start,limit)  : " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getOrganizationIdByOrgCode(String orgCode) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by orgCode  : " + orgCode));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getOrganizationIdByOrgCode", new Object[]{orgCode});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by orgCode  : " + orgCode));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Long getOrganizationIdByCreditCode(String creditCode) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by creditCode  : " + creditCode));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getOrganizationIdByCreditCode", new Object[]{creditCode});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by creditCode  : " + creditCode));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Integer countOrganizationIdsByType(Integer type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by type  : " + type));
        }
        Integer count = null;
        try {
            count = this.dao.count("getOrganizationIdsByType", new Object[]{type});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by type)  : " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getOrganizationIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getOrganizationIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countOrganizationIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getOrganizationIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getOrganizationIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public Long getOrganizationIdByName(String name) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by name  : " + name));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getOrganizationIdByName", new Object[]{name});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by name  : " + name));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }
}

