/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.wealth.user.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.consign.constant.OpEntrustWayEnum;
import com.ptteng.wealth.consign.model.in.OrganBindCardIn;
import com.ptteng.wealth.consign.model.in.OrganOpenAccountIn;
import com.ptteng.wealth.consign.model.out.CardBindingOut;
import com.ptteng.wealth.consign.model.out.CustomerInfo;
import com.ptteng.wealth.consign.model.out.OpenAccountOut;
import com.ptteng.wealth.consign.service.ConsignmentService;
import com.ptteng.wealth.user.Environment;
import com.ptteng.wealth.user.model.OrgApply;
import com.ptteng.wealth.user.model.Organization;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.model.UserOpenidRelation;
import com.ptteng.wealth.user.service.OrgApplyService;
import com.ptteng.wealth.user.service.OrganizationService;
import com.ptteng.wealth.user.service.UserOpenidRelationService;
import com.ptteng.wealth.user.service.UserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component(value="OrgApplyService")
public class OrgApplyServiceImpl
extends BaseDaoServiceImpl
implements OrgApplyService {
    private static final Log log = LogFactory.getLog(OrgApplyServiceImpl.class);
    private static final Log orgApplyLog = LogFactory.getLog((String)"orgApply");
    private UserService userService;
    private ConsignmentService consignmentService;
    private OrganizationService organizationService;
    private UserOpenidRelationService userOpenidRelationService;
    private Environment environment;

    public Long insert(OrgApply orgApply) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + orgApply));
        if (orgApply == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        orgApply.setCreateAt(Long.valueOf(currentTimeMillis));
        orgApply.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)orgApply);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + orgApply));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<OrgApply> insertList(List<OrgApply> orgApplyList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (orgApplyList == null ? "null" : Integer.valueOf(orgApplyList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(orgApplyList)) {
            return new ArrayList<OrgApply>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (OrgApply orgApply : orgApplyList) {
            orgApply.setCreateAt(Long.valueOf(currentTimeMillis));
            orgApply.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(orgApplyList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + orgApplyList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(OrgApply.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(OrgApply orgApply) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (orgApply == null ? "null" : orgApply.getId())));
        boolean result = false;
        if (orgApply == null) {
            return true;
        }
        orgApply.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)orgApply);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + orgApply));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + orgApply));
        }
        return result;
    }

    public boolean updateList(List<OrgApply> orgApplyList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (orgApplyList == null ? "null" : Integer.valueOf(orgApplyList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(orgApplyList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (OrgApply orgApply : orgApplyList) {
            orgApply.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(orgApplyList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + orgApplyList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + orgApplyList.size()));
        return result;
    }

    public OrgApply getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        OrgApply orgApply = null;
        if (id == null) {
            return orgApply;
        }
        try {
            orgApply = (OrgApply)this.dao.get(OrgApply.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return orgApply;
    }

    public List<OrgApply> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List orgApply = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<OrgApply>();
        }
        try {
            orgApply = this.dao.getList(OrgApply.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (orgApply == null ? "null" : Integer.valueOf(orgApply.size()))));
        return orgApply;
    }

    public Long getOrgApplyIdByMobile(String mobile) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by mobile  : " + mobile));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getOrgApplyIdByMobile", new Object[]{mobile});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by mobile  : " + mobile));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getOrgApplyIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getOrgApplyIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countOrgApplyIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getOrgApplyIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getOrgApplyIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public List<Long> orgCodeIds(String code) throws ServiceException, ServiceDaoException {
        List idList = null;
        try {
            idList = this.dao.getIdList("getOrgApplyIdByOrgCode", new Object[]{code}, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), false);
        }
        catch (DaoException e) {
            log.error((Object)" get ids  wrong by start,limit)  : 0 , 2147483647");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> licenseCodeIds(String code) throws ServiceException, ServiceDaoException {
        List idList = null;
        try {
            idList = this.dao.getIdList("getOrgApplyIdByLicenceCode", new Object[]{code}, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), false);
        }
        catch (DaoException e) {
            log.error((Object)" get ids  wrong by start,limit)  : 0 , 2147483647");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> creditCodeIds(String code) throws ServiceException, ServiceDaoException {
        List idList = null;
        try {
            idList = this.dao.getIdList("getOrgApplyIdByCreditCode", new Object[]{code}, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), false);
        }
        catch (DaoException e) {
            log.error((Object)" get ids  wrong by start,limit)  : 0 , 2147483647");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer createOrg(OrgApply orgApply) throws ServiceDaoException, ServiceException {
        orgApplyLog.info((Object)"============================================================");
        orgApplyLog.info((Object)("orgApply is  " + orgApply.getId()));
        boolean result = false;
        if (null != orgApply) {
            try {
                User user;
                Long userId;
                block20: {
                    int fundCode;
                    block19: {
                        Long relationID = this.userOpenidRelationService.getUserOpenidRelationIdByOpenidAndStatus(orgApply.getMobile(), "org_mobile");
                        if (null == relationID) {
                            return -2000;
                        }
                        UserOpenidRelation relation = this.userOpenidRelationService.getObjectById(relationID);
                        if (null == relation) {
                            return -2000;
                        }
                        userId = relation.getTypeId();
                        orgApplyLog.info((Object)(" userId = " + userId));
                        user = this.userService.getObjectById(userId);
                        fundCode = 0;
                        OpenAccountOut openAccountOut = null;
                        try {
                            if (User.ALREADY_OPEN_ACCOUNT.equals(user.getAccStatus()) && user.getFundAccount() > 0) {
                                orgApplyLog.info((Object)(" already open account  orgApply id = " + orgApply.getId()));
                                fundCode = user.getFundAccount();
                                break block19;
                            }
                            OrganOpenAccountIn organOpenAccountIn = new OrganOpenAccountIn();
                            organOpenAccountIn.setFunctionId(21000);
                            organOpenAccountIn.setUserId(userId + "");
                            organOpenAccountIn.setActionIn(0);
                            organOpenAccountIn.setOrganName(orgApply.getName());
                            organOpenAccountIn.setPassword(orgApply.getPayPwd());
                            organOpenAccountIn.setMobiletelephone(orgApply.getMobile());
                            organOpenAccountIn.setOrganCode(orgApply.getUseOrgCode());
                            organOpenAccountIn.setSaleLicence(orgApply.getUseLicenseCode());
                            organOpenAccountIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
                            openAccountOut = this.consignmentService.openOrgan(organOpenAccountIn);
                            orgApplyLog.info((Object)("S4: openAccountOut: " + openAccountOut));
                            if (0 == openAccountOut.getErrorNo()) {
                                fundCode = openAccountOut.getFundAccount();
                                orgApplyLog.info((Object)("fundcode: " + fundCode));
                                if (fundCode > 0) {
                                    user.setAccStatus(User.ALREADY_OPEN_ACCOUNT);
                                } else {
                                    user.setAccStatus(User.NO_OPEN_ACCOUNT);
                                }
                                user.setFundAccount(Integer.valueOf(fundCode));
                                user.setPayPwd(orgApply.getPayPwd());
                                this.userService.update(user);
                                break block19;
                            }
                            CustomerInfo customerInfo = this.consignmentService.getCustomerInfo(userId + "");
                            if (null != customerInfo && customerInfo.getFundAccount() > 0) {
                                fundCode = customerInfo.getFundAccount();
                                user.setAccStatus(User.ALREADY_OPEN_ACCOUNT);
                                user.setFundAccount(Integer.valueOf(fundCode));
                                user.setPayPwd(orgApply.getPayPwd());
                                this.userService.update(user);
                                break block19;
                            }
                            return openAccountOut.getErrorNo();
                        }
                        catch (Exception e) {
                            orgApplyLog.info((Object)e.getMessage());
                            e.printStackTrace(System.out);
                            return -3015;
                        }
                    }
                    try {
                        if (1 == user.getCardStatus()) {
                            orgApplyLog.info((Object)(" already binding card  account  " + user.getId()));
                            break block20;
                        }
                        OrganBindCardIn organBindCardIn = new OrganBindCardIn();
                        organBindCardIn.setFunctionId(21001);
                        organBindCardIn.setUserId(userId + "");
                        organBindCardIn.setFundAccount(fundCode);
                        organBindCardIn.setPassword(orgApply.getPayPwd());
                        organBindCardIn.setOrganName(orgApply.getName());
                        organBindCardIn.setBankNo(orgApply.getBank());
                        organBindCardIn.setBankAccount(orgApply.getCardNo());
                        organBindCardIn.setOrganCode(orgApply.getUseOrgCode());
                        organBindCardIn.setSaleLicence(orgApply.getUseLicenseCode());
                        organBindCardIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
                        organBindCardIn.setIdKind("P");
                        CardBindingOut cardBindingOut = this.consignmentService.orgBindcard(organBindCardIn);
                        if (0 == cardBindingOut.getErrorNo()) {
                            orgApplyLog.info((Object)(" binding card success id = " + orgApply.getId()));
                            user.setCardStatus(User.CARD_HAVE);
                            user.setPayPwd(orgApply.getPayPwd());
                            this.userService.update(user);
                            orgApplyLog.info((Object)(" binding success update orgApply success id = " + orgApply.getId()));
                            break block20;
                        }
                        orgApplyLog.info((Object)("s5 cardBindingOut is  " + cardBindingOut));
                        return cardBindingOut.getErrorNo();
                    }
                    catch (Exception e) {
                        orgApplyLog.info((Object)e.getMessage());
                        e.printStackTrace(System.out);
                        return -3015;
                    }
                }
                Organization organization = this.organizationService.getObjectById(userId);
                boolean bOrgInsert = false;
                if (null == organization) {
                    bOrgInsert = true;
                    organization = new Organization();
                    organization.setId(userId);
                }
                organization.setLicenceCode(orgApply.getLicenceCode());
                organization.setCreditCode(orgApply.getCreditCode());
                organization.setOrgCode(orgApply.getOrgCode());
                organization.setLicenceImg(orgApply.getLicenceImg());
                organization.setPermitImg(orgApply.getPermitImg());
                organization.setTaxImg(orgApply.getTaxImg());
                organization.setType(orgApply.getOrgType());
                organization.setCreateBy(userId);
                organization.setName(orgApply.getName());
                if (bOrgInsert) {
                    this.organizationService.insert(organization);
                    orgApplyLog.info((Object)(" save organization id : " + userId));
                } else {
                    this.organizationService.update(organization);
                    orgApplyLog.info((Object)(" update organization id : " + userId));
                }
                user.setName(organization.getName());
                user.setVerifyStatus(User.VERIFY_YES);
                this.userService.update(user);
                orgApplyLog.info((Object)"============================================================");
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                orgApplyLog.error((Object)e.getMessage());
                return -1;
            }
        }
        return 0;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public OrganizationService getOrganizationService() {
        return this.organizationService;
    }

    public void setOrganizationService(OrganizationService organizationService) {
        this.organizationService = organizationService;
    }

    public UserOpenidRelationService getUserOpenidRelationService() {
        return this.userOpenidRelationService;
    }

    public void setUserOpenidRelationService(UserOpenidRelationService userOpenidRelationService) {
        this.userOpenidRelationService = userOpenidRelationService;
    }

    public ConsignmentService getConsignmentService() {
        return this.consignmentService;
    }

    public void setConsignmentService(ConsignmentService consignmentService) {
        this.consignmentService = consignmentService;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

